"""Модуль отрисовки.

Данный модуль содержит инструменты, предназначенные для отрисовки
геопространственных и прочих данных.
"""

# depends on axipy.da, axipy.cs, axipy.utl

from .context import *  # depends on axipy.cs, axipy.utl
from .label import *  # depends on axipy.da
from .layer import *  # depends on label, axipy.da, axipy.cs, axipy.utl
from .thematic_layer import *  # depends on layer, axipy.da
from .map_ import *  # depends on context, label, layer, axipy.cs, axipy.utl
from .legend import *  # depends on context, layer, axipy.da, axipy.utl
from .report import *  # depends on context, legend, map_, axipy.da, axipy.cs, axipy.utl


def __getattr__(name: str):
    """
    Backwards compatibility.
    """
    old_names = {
        "map": map_,
    }
    if name in old_names:
        return old_names[name]

    raise AttributeError(f"module {__name__!r} has no attribute {name!r}")
