from .pnt import Pnt
from PySide2.QtCore import QPointF, QRect, QRectF
from typing import Optional, Union

class Rect:
    def __init__(self, xmin: float, ymin: float, xmax: float, ymax: float) -> None: ...
    @classmethod
    def from_qt(cls, r: Union[QRectF, QRect]) -> Optional['Rect']: ...
    def to_qt(self) -> QRectF: ...
    @property
    def xmin(self) -> float: ...
    @xmin.setter
    def xmin(self, v: float): ...
    @property
    def ymin(self) -> float: ...
    @ymin.setter
    def ymin(self, v: float): ...
    @property
    def xmax(self) -> float: ...
    @xmax.setter
    def xmax(self, v: float): ...
    @property
    def ymax(self) -> float: ...
    @ymax.setter
    def ymax(self, v: float): ...
    @property
    def center(self) -> Pnt: ...
    @center.setter
    def center(self, p: Pnt): ...
    def __eq__(self, other) -> bool: ...
    @classmethod
    def eq_approx(cls, rect1: Rect, rect2: Rect, precision: float = ...) -> bool: ...
    @property
    def is_empty(self) -> bool: ...
    @property
    def is_valid(self) -> bool: ...
    def normalize(self) -> None: ...
    @property
    def width(self) -> float: ...
    @property
    def height(self) -> float: ...
    def merge(self, other: Rect) -> Rect: ...
    def intersected(self, other: Rect) -> Rect: ...
    def translated(self, dx: float, dy: float) -> Rect: ...
    def expanded(self, dx: float, dy: float) -> Rect: ...
    def contains(self, other: Union[Pnt, QPointF, 'Rect', QRectF]) -> bool: ...
