import enum
from .geometry import Geometry
from PySide2.QtGui import QColor, QPainter
from typing import NamedTuple, Optional

class Style:
    def __init__(self) -> None: ...
    @classmethod
    def from_mapinfo(cls, mapbasic_string: str) -> Optional['Style']: ...
    def to_mapinfo(self) -> str: ...
    def __eq__(self, other) -> bool: ...
    @classmethod
    def for_geometry(cls, geom: Geometry) -> Style: ...
    def draw(self, geometry: Geometry, painter: QPainter): ...
    def clone(self) -> Style: ...

class PointStyle(Style):
    def __init__(self) -> None: ...
    @staticmethod
    def create_mi_compat(symbol: int = ..., color: QColor = ..., pointSize: int = ...) -> PointCompatStyle: ...
    @staticmethod
    def create_mi_font(symbol: int = ..., color: QColor = ..., size: int = ..., fontname: str = ..., fontstyle: int = ..., rotation: float = ...) -> PointFontStyle: ...
    @staticmethod
    def create_mi_picture(filename: str, color: QColor = ..., size: int = ..., customstyle: int = ...) -> PointPictureStyle: ...
    @property
    def color(self) -> QColor: ...
    @color.setter
    def color(self, c: QColor): ...

class PointCompatStyle(PointStyle):
    def __init__(self, symbol: int = ..., color: QColor = ..., pointSize: int = ...) -> None: ...
    @property
    def size(self) -> int: ...
    @size.setter
    def size(self, s: int): ...
    @property
    def symbol(self) -> int: ...
    @symbol.setter
    def symbol(self, s: int): ...

class PointFontStyle(PointStyle):
    def __init__(self, symbol: int = ..., color: QColor = ..., size: int = ..., fontname: str = ..., fontstyle: int = ..., rotation: float = ...) -> None: ...
    @property
    def symbol(self) -> int: ...
    @symbol.setter
    def symbol(self, s: int): ...
    @property
    def size(self) -> int: ...
    @size.setter
    def size(self, s: int): ...
    @property
    def font_name(self) -> str: ...
    @font_name.setter
    def font_name(self, s: str): ...
    @property
    def rotation(self) -> float: ...
    @rotation.setter
    def rotation(self, s: float): ...
    @property
    def bold(self) -> bool: ...
    @bold.setter
    def bold(self, v: bool): ...
    @property
    def has_shadow(self) -> bool: ...
    @has_shadow.setter
    def has_shadow(self, v: bool): ...
    @property
    def black_border(self) -> bool: ...
    @black_border.setter
    def black_border(self, v: bool): ...
    @property
    def white_border(self) -> bool: ...
    @white_border.setter
    def white_border(self, v: bool): ...

class PointPictureStyle(PointStyle):
    def __init__(self, filename: str, color: QColor = ..., size: int = ..., customstyle: int = ...) -> None: ...
    @property
    def size(self) -> int: ...
    @size.setter
    def size(self, s: int): ...
    @property
    def filename(self) -> str: ...
    @filename.setter
    def filename(self, s: str): ...
    @property
    def show_background(self) -> bool: ...
    @show_background.setter
    def show_background(self, b: bool): ...
    @property
    def apply_color(self) -> bool: ...
    @apply_color.setter
    def apply_color(self, b: bool): ...
    @property
    def actual_size(self) -> bool: ...
    @actual_size.setter
    def actual_size(self, b: bool): ...

class LineStyle(Style):
    def __init__(self, pattern: int = ..., color: QColor = ..., width: int = ...) -> None: ...
    @property
    def color(self) -> QColor: ...
    @color.setter
    def color(self, c: QColor): ...
    @property
    def pattern(self) -> int: ...
    @pattern.setter
    def pattern(self, id: int): ...
    @property
    def width(self) -> int: ...
    @width.setter
    def width(self, w: int): ...

class FillStyle(Style):
    def __init__(self, pattern: int = ..., color: QColor = ...) -> None: ...
    @property
    def color(self) -> QColor: ...
    @color.setter
    def color(self, c: QColor): ...
    @property
    def bg_color(self) -> QColor: ...
    @bg_color.setter
    def bg_color(self, c: QColor): ...
    @property
    def pattern(self) -> int: ...
    @pattern.setter
    def pattern(self, id: int): ...

class PolygonStyle(Style):
    def __init__(self, pattern: int = ..., color: QColor = ..., pattern_pen: int = ...) -> None: ...
    def set_pen(self, pattern: int = ..., color: QColor = ..., width: int = ...): ...
    def set_brush(self, pattern: int = ..., color: QColor = ..., bgColor: QColor = ...): ...
    @property
    def border(self) -> LineStyle: ...
    @property
    def fill(self) -> FillStyle: ...

class TextBackgroundType(int, enum.Enum):
    NoBackground: int
    Outline: int
    Frame: int

class TextStyleEffects(NamedTuple):
    bold: bool
    italic: bool
    shadow: bool
    spacing: bool
    underline: bool
    capital: bool

class TextCallout(int, enum.Enum):
    NoCallout: int
    Line: int
    Arrow: int

class TextStyle(Style):
    def __init__(self, fontname: str, size: int, style: int = ..., forecolor: QColor = ..., backcolor: QColor = ...) -> None: ...
    @property
    def size(self) -> float: ...
    @size.setter
    def size(self, v: float): ...
    @property
    def color(self) -> QColor: ...
    @color.setter
    def color(self, c: QColor): ...
    @property
    def bg_color(self) -> QColor: ...
    @bg_color.setter
    def bg_color(self, c: QColor): ...
    @property
    def fontname(self) -> str: ...
    @fontname.setter
    def fontname(self, v: str): ...
    @property
    def bold(self) -> bool: ...
    @bold.setter
    def bold(self, v: bool): ...
    @property
    def italic(self) -> bool: ...
    @italic.setter
    def italic(self, v: bool): ...
    @property
    def shadow(self) -> bool: ...
    @shadow.setter
    def shadow(self, v: bool): ...
    @property
    def spacing(self) -> bool: ...
    @spacing.setter
    def spacing(self, v: bool): ...
    @property
    def underline(self) -> bool: ...
    @underline.setter
    def underline(self, v: bool): ...
    @property
    def capital(self) -> bool: ...
    @capital.setter
    def capital(self, v: bool): ...
    @property
    def bg_type(self) -> TextBackgroundType: ...
    @bg_type.setter
    def bg_type(self, v: TextBackgroundType): ...
    @property
    def callout(self) -> TextCallout: ...
    @callout.setter
    def callout(self, v: TextCallout): ...
    @property
    def callout_style(self) -> LineStyle: ...
    @callout_style.setter
    def callout_style(self, v: LineStyle): ...
    @property
    def effects(self) -> TextStyleEffects: ...

class CollectionStyle(Style):
    def __init__(self) -> None: ...
    def for_point(self, style: PointStyle): ...
    def for_line(self, style: LineStyle): ...
    def for_polygon(self, style: PolygonStyle): ...
    def for_text(self, style: TextStyle): ...
    @property
    def text(self) -> Optional[TextStyle]: ...
    @property
    def line(self) -> Optional[LineStyle]: ...
    @property
    def polygon(self) -> Optional[PolygonStyle]: ...
    @property
    def point(self) -> Optional[PointStyle]: ...
    def find_style(self, geom: Geometry) -> Style: ...
