from ..data_object import DataObject, Table
from ..feature import Feature
from ..schema import Schema
from typing import Iterator

class Source(dict):
    def __init__(self, *args) -> None: ...
    def open(self) -> DataObject: ...

class Destination(dict):
    def __init__(self, schema: Schema, *args) -> None: ...
    def create_open(self) -> DataObject: ...
    def export(self, features: Iterator[Feature]): ...
    def export_from(self, source: Source, copy_schema: bool = ...): ...
    def export_from_table(self, table: Table, copy_schema: bool = ...): ...

class ExportParameters:
    createIndex: bool
    dropTable: bool
    geometryColumnName: str
    renditonColumnName: str
    srid: int
    logFile: str
    errorFile: str
    mapCatalog: bool
    geometryAsText: bool
    fixGeometry: bool
    def to_dict(self): ...
