from typing import overload
import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtWidgets
import typing
T = typing.TypeVar('T')

class QGraphicsSvgItem(PySide2.QtWidgets.QGraphicsObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, fileName: str, parentItem: typing.Union[PySide2.QtWidgets.QGraphicsItem,None] = ..., children: typing.Any = ..., childrenChanged: typing.Callable = ..., destroyed: typing.Callable = ..., effect: typing.Any = ..., elementId: str = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., height: float = ..., heightChanged: typing.Callable = ..., maximumCacheSize: PySide2.QtCore.QSize = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., parent: typing.Any = ..., parentChanged: typing.Callable = ..., pos: PySide2.QtCore.QPointF = ..., rotation: float = ..., rotationChanged: typing.Callable = ..., scale: float = ..., scaleChanged: typing.Callable = ..., transformOriginPoint: PySide2.QtCore.QPointF = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: float = ..., widthChanged: typing.Callable = ..., x: float = ..., xChanged: typing.Callable = ..., y: float = ..., yChanged: typing.Callable = ..., z: float = ..., zChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parentItem: typing.Union[PySide2.QtWidgets.QGraphicsItem,None] = ..., children: typing.Any = ..., childrenChanged: typing.Callable = ..., destroyed: typing.Callable = ..., effect: typing.Any = ..., elementId: str = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., height: float = ..., heightChanged: typing.Callable = ..., maximumCacheSize: PySide2.QtCore.QSize = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., opacity: float = ..., opacityChanged: typing.Callable = ..., parent: typing.Any = ..., parentChanged: typing.Callable = ..., pos: PySide2.QtCore.QPointF = ..., rotation: float = ..., rotationChanged: typing.Callable = ..., scale: float = ..., scaleChanged: typing.Callable = ..., transformOriginPoint: PySide2.QtCore.QPointF = ..., visible: bool = ..., visibleChanged: typing.Callable = ..., width: float = ..., widthChanged: typing.Callable = ..., x: float = ..., xChanged: typing.Callable = ..., y: float = ..., yChanged: typing.Callable = ..., z: float = ..., zChanged: typing.Callable = ...) -> None: ...
    def boundingRect(self) -> PySide2.QtCore.QRectF: ...
    def elementId(self) -> str: ...
    def isCachingEnabled(self) -> bool: ...
    def maximumCacheSize(self) -> PySide2.QtCore.QSize: ...
    def paint(self, painter: PySide2.QtGui.QPainter, option: PySide2.QtWidgets.QStyleOptionGraphicsItem, widget: typing.Union[PySide2.QtWidgets.QWidget,None] = ...) -> None: ...
    def renderer(self) -> QSvgRenderer: ...
    def setCachingEnabled(self, arg__1: bool) -> None: ...
    def setElementId(self, id: str) -> None: ...
    def setMaximumCacheSize(self, size: PySide2.QtCore.QSize) -> None: ...
    def setSharedRenderer(self, renderer: QSvgRenderer) -> None: ...
    def type(self) -> int: ...

class QSvgGenerator(PySide2.QtGui.QPaintDevice):
    def __init__(self) -> None: ...
    def description(self) -> str: ...
    def fileName(self) -> str: ...
    def metric(self, metric: PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def outputDevice(self) -> PySide2.QtCore.QIODevice: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def resolution(self) -> int: ...
    def setDescription(self, description: str) -> None: ...
    def setFileName(self, fileName: str) -> None: ...
    def setOutputDevice(self, outputDevice: PySide2.QtCore.QIODevice) -> None: ...
    def setResolution(self, dpi: int) -> None: ...
    def setSize(self, size: PySide2.QtCore.QSize) -> None: ...
    def setTitle(self, title: str) -> None: ...
    @overload
    def setViewBox(self, viewBox: PySide2.QtCore.QRect) -> None: ...
    @overload
    def setViewBox(self, viewBox: PySide2.QtCore.QRectF) -> None: ...
    def size(self) -> PySide2.QtCore.QSize: ...
    def title(self) -> str: ...
    def viewBox(self) -> PySide2.QtCore.QRect: ...
    def viewBoxF(self) -> PySide2.QtCore.QRectF: ...

class QSvgRenderer(PySide2.QtCore.QObject):
    repaintNeeded: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, contents: typing.Union[PySide2.QtCore.QByteArray,bytes], parent: typing.Union[PySide2.QtCore.QObject,None] = ..., aspectRatioMode: PySide2.QtCore.Qt.AspectRatioMode = ..., currentFrame: int = ..., destroyed: typing.Callable = ..., framesPerSecond: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., repaintNeeded: typing.Callable = ..., viewBox: PySide2.QtCore.QRectF = ...) -> None: ...
    @overload
    def __init__(self, contents: PySide2.QtCore.QXmlStreamReader, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., aspectRatioMode: PySide2.QtCore.Qt.AspectRatioMode = ..., currentFrame: int = ..., destroyed: typing.Callable = ..., framesPerSecond: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., repaintNeeded: typing.Callable = ..., viewBox: PySide2.QtCore.QRectF = ...) -> None: ...
    @overload
    def __init__(self, filename: str, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., aspectRatioMode: PySide2.QtCore.Qt.AspectRatioMode = ..., currentFrame: int = ..., destroyed: typing.Callable = ..., framesPerSecond: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., repaintNeeded: typing.Callable = ..., viewBox: PySide2.QtCore.QRectF = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., aspectRatioMode: PySide2.QtCore.Qt.AspectRatioMode = ..., currentFrame: int = ..., destroyed: typing.Callable = ..., framesPerSecond: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., repaintNeeded: typing.Callable = ..., viewBox: PySide2.QtCore.QRectF = ...) -> None: ...
    def animated(self) -> bool: ...
    def animationDuration(self) -> int: ...
    def aspectRatioMode(self) -> PySide2.QtCore.Qt.AspectRatioMode: ...
    def boundsOnElement(self, id: str) -> PySide2.QtCore.QRectF: ...
    def currentFrame(self) -> int: ...
    def defaultSize(self) -> PySide2.QtCore.QSize: ...
    def elementExists(self, id: str) -> bool: ...
    def framesPerSecond(self) -> int: ...
    def isValid(self) -> bool: ...
    @overload
    def load(self, contents: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> bool: ...
    @overload
    def load(self, contents: PySide2.QtCore.QXmlStreamReader) -> bool: ...
    @overload
    def load(self, filename: str) -> bool: ...
    def matrixForElement(self, id: str) -> PySide2.QtGui.QMatrix: ...
    @overload
    def render(self, p: PySide2.QtGui.QPainter, elementId: str, bounds: PySide2.QtCore.QRectF = ...) -> None: ...
    @overload
    def render(self, p: PySide2.QtGui.QPainter, bounds: PySide2.QtCore.QRectF) -> None: ...
    @overload
    def render(self, p: PySide2.QtGui.QPainter) -> None: ...
    def setAspectRatioMode(self, mode: PySide2.QtCore.Qt.AspectRatioMode) -> None: ...
    def setCurrentFrame(self, arg__1: int) -> None: ...
    def setFramesPerSecond(self, num: int) -> None: ...
    @overload
    def setViewBox(self, viewbox: PySide2.QtCore.QRect) -> None: ...
    @overload
    def setViewBox(self, viewbox: PySide2.QtCore.QRectF) -> None: ...
    def transformForElement(self, id: str) -> PySide2.QtGui.QTransform: ...
    def viewBox(self) -> PySide2.QtCore.QRect: ...
    def viewBoxF(self) -> PySide2.QtCore.QRectF: ...

class QSvgWidget(PySide2.QtWidgets.QWidget):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, file: str, parent: typing.Union[PySide2.QtWidgets.QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtWidgets.QWidget,None] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def load(self, contents: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> None: ...
    @overload
    def load(self, file: str) -> None: ...
    def paintEvent(self, event: PySide2.QtGui.QPaintEvent) -> None: ...
    def renderer(self) -> QSvgRenderer: ...
    def sizeHint(self) -> PySide2.QtCore.QSize: ...
