'''

Пример пакетной загрузки локальных таблиц в другой каталог с возможностью изменения координатной системы.
Загружается как расширение. 

Последовательность действий:
1. Добавляем файлы из файловой системы.
2. Если это необходимо, устанавливаем галку напротив "Сменить проекцию". В этом случае все файлы будут сохранены в данной проекции.
По умолчанию будет взята проекция первого добавленного входного файла.
3. Если нам необходимо сохранить геометрические координаты, минуя их преобразование, необходимо поставить галку "Не конвертировать геометрию при смене проекции"
4. Если необходимо изменить охват (MBR) таблицы, это можно сделать посредством кнопки "Сменить охват проекции".
5. Производим экспорт. При  этом будет произведен запрос на выбор выходного каталога


dependencies:
MainWindow
'''

from PyQt5.QtWidgets import QDockWidget
from PyQt5.QtGui import QIcon
from PyQt5.QtCore import Qt

import axioma.app
from axioma.core.dp import DataCatalog

class DockFileExtension(axioma.core.plugin.Extension):
    def __init__(self):
        super().__init__()
        self.mainWindow = self.createDependencyGetter(axioma.app.MainWindow)

    def onResolved(self):
     try:
        from .exportToFileWidget import ExportToFileWidget
        widget = ExportToFileWidget(self.mainWindow().dataCatalog(), self.mainWindow())
        dock = QDockWidget("Экспорт", self.mainWindow())
        dock.setWidget(widget)
        self.mainWindow().addDockWidget(Qt.RightDockWidgetArea, dock)
        self.mainWindow().addPanel(dock)
     except Exception as ex:
        print(ex)

def createExtensions():
    return [DockFileExtension()]
