from .data_provider import DataProvider, Table, DataObject
from .source import Source, Destination, Schema
from typing import List, Optional


class OgrSource(Source):
    pass


class OgrDataProvider(DataProvider):
    """Провайдер для векторных данных OGR.
    
    Note:
        Ссылку на провайдер можно получить через глобальную переменную :attr:`axipy.da.provider_manager.ogr`.
    """
    _identifier = 'OgrDataProvider'

    def get_source(self, data: str, dataobject: str, alias: str = None) -> Source:
        """Создает источник данных.

        Args:
          data: Источник данных или имя файла.
          dataobject: Наименование таблицы
        """
        return OgrSource(
            Source._provider(self.id),
            Source._alias(alias),
            {
                'src': data,
                'dataobject': dataobject
            }
        )

    def open(self, data: str, dataobject: str, alias: str = None) -> DataObject:
        """Открывает объект данных.

        Args:
          data: Источник данных или имя файла.
          dataobject: Наименование таблицы
          alias: Псевдоним для открываемой таблицы.
        """
        return self.get_source(data, dataobject, alias).open()

    def file_extensions(self) -> List[str]:
        return list(filter(lambda v: v not in ['shp', 'shz'], super().file_extensions()))

    def get_destination(self):
        """
        Attention:
            Не поддерживается.

        Raises:
            NotImplementedError
        """
        raise NotImplementedError
    
    def create_open(self):
        """
        Attention:
            Не поддерживается.

        Raises:
            NotImplementedError
        """
        raise NotImplementedError
