import os
import subprocess
from pathlib import Path
from typing import Optional
from .dependency_installer import DependencyInstaller, InstallError, Dependencies
import logging
import platform


__all__ = [
    'PipDependencyInstaller',
]


def python_interpreter() -> Optional[Path]:
    import os
    result = Path(os.environ['AXIOMA_PYTHON_INTERPRETER'])
    return result if result.is_file() else None


class PipDependencyInstaller(DependencyInstaller):

    def __to_list(self, data):
        list_filter = filter(None, data.split("\n"))
        return list(list_filter)

    def install(self, dependency: Dependencies):
        executable = python_interpreter()
        if not executable:
            raise InstallError('Python interpreter is not found')

        # split process by packages
        deps_file = open(str(dependency.requirements), 'r')
        data = deps_file.read()
        deps_file.close()

        if platform.system() == 'Windows':
            flags = {'creationflags':subprocess.CREATE_NO_WINDOW}
        else:
            flags = {}

        for package in self.__to_list(data):
            logging.info(f'--- Package deps: {package} ---')
            try:
                exit_string = subprocess.run(
                    [str(executable), '-m', 'pip', 'install',
                        '--user', package
                    ], stdout=subprocess.PIPE, **flags
                ).stdout
                for m in self.__to_list(exit_string.decode()):
                    logging.info(m)
            except subprocess.CalledProcessError as ex:
                logging.error(f"Execution error:\"{ex.cmd}\"" )
                raise
            except:
                raise

