import axioma.gui
import sys
import traceback

from axioma.gui import RibbonExtension

class ActionExtension(axioma.gui.NativeActionExtension):
    def __init__(self, factory, id, category = "", tab = "", group = ""):
        super().__init__(id, axioma.gui.RibbonActionInfo(category, tab, group))
        self.__factory = factory

    def createAction_impl(self, parent):
        try:
            return self.__factory(parent)
        except:
            traceback.print_exc()
            return None

class ActionController(axioma.gui.ActionControllerWithDependencies):
    def __init__(self, parent = None):
        super().__init__(parent)
        self.gui = self.createDependencyGetter(axioma.gui.Gui)

class ActionControllerExtension(axioma.gui.NativeActionControllerExtension):
    def __init__(self, controllerFactory, actionId, category = "", tab = "", group = "", icon = None, text = None):
        controller = controllerFactory()
        super().__init__(controller, actionId, axioma.gui.RibbonActionInfo(tab, group, category))
        self.__icon = icon
        self.__text = text

    def customizeAction(self, action):
        if self.__icon:
            action.setIcon(self.__icon)
        if self.__text:
            action.setText(self.__text)


class ToolControllerExtension(axioma.gui.NativeToolControllerExtension):
    def __init__(self, controllerFactory, actionId, category = "", tab = "", group = "", icon = None, text = None):
        controller = controllerFactory()
        super().__init__(controller, actionId, axioma.gui.RibbonActionInfo(tab, group, category))
        self.__icon = icon
        self.__text = text

    def customizeAction(self, action):
        if self.__icon is not None:
            action.setIcon(self.__icon)
        if self.__text:
            action.setText(self.__text)

class ToolController(axioma.gui.ToolControllerTemplateBase):
    def __init__(self, widgetClass, parent):
        super().__init__(parent)
        self.__widgetClass = widgetClass
        self.gui = self.createDependencyGetter(axioma.gui.Gui)

    def setup(self):
        super().setup()
        self.widgetManagerService().connectWidgetChanged(self.__widgetClass, self, lambda: self.updateEnabled())

    def activeWidget(self):
        return self.widgetManagerService().activeWidget(self.__widgetClass)

    def isEnabled(self):
        active = self.activeWidget()
        if active is None:
            return False
        return self.isEnabledFor(active)

    def isEnabledFor(self, widget):
        return True

class BasicToolController(ToolController):
    def __init__(self, widgetClass, toolClass, parent = None):
        super().__init__(widgetClass, parent)
        self.__toolClass = toolClass

    def createTool(self, widget):
        return self.__toolClass(widget)

class DrawingToolController(axioma.gui.NativeDrawingToolController):
    def __init__(self, parent=None):
        super().__init__( parent)

    def isEnabled(self, view):
        active = self.activeWidget()
        if active is None:
            return False
        return True

class BasicToolExtension(ToolControllerExtension):
    def __init__(self, toolClass, widgetClass, actionId, category = "", tab = "", group = "", icon = None, text = None):
        controllerFactory = lambda: BasicToolController(widgetClass, toolClass)
        super().__init__(controllerFactory, actionId, category = category, tab = tab, group = group, icon = icon, text = text)
