from .data_provider import DataProvider
from .source import Source, Destination, Schema
from typing import List


class GenericSource(Source):
    pass


class GenericDestination(Destination):
    pass


class GenericDataProvider(DataProvider):

    def get_source(self, filepath: str, **kwargs) -> GenericSource:
        return GenericSource(
            Source._provider(self.id),
            Source._table_file(filepath),
            kwargs
        )

    def get_destination(self, **kwargs) -> GenericDestination:
        if 'export' not in self.info:
            raise NotImplementedError
        return GenericDestination(
            Source._provider(self.id),
            kwargs
        )
