import os.path
from .parser import (IParser, Metadata, LocationPath
        , MANIFEST_FILE_NAME, ENTRY_POINT)


class FolderParser(IParser):
    def parse(self, location_path: LocationPath) -> Metadata:
        manifest_filepath = os.path.join(location_path, MANIFEST_FILE_NAME)
        with open(manifest_filepath, encoding='utf-8') as manifest_file:
            result = self.read_config(manifest_file)
        doc_dir = os.path.join(location_path, 'documentation')
        if os.path.isdir(doc_dir):
            def is_doc_entry(filename: str): return filename.startswith(
                'index') and filename.endswith('html')
            doc_entry_points = filter(is_doc_entry, os.listdir(doc_dir))
            result['documentation'] = [os.path.join(
                doc_dir, entry) for entry in doc_entry_points]
        return result

    @staticmethod
    def supports(location_path: LocationPath) -> bool:
        return True
