import sys, traceback
from axioma.core import PythonProgressHandler, Task

class PythonTask(Task):
    '''
    Абстрактное описание задачи которую можно выполнить в отдельном потоке

    :param fn: Пользовательская функция которая будет выполнятся. В неё 
    передается список args и словарь kwargs
    :param args: Список аргументов передаваемый в функцию при запуске
    :param kwargs: Словарь передаваемый в функцию при запуске
    '''

    def __init__(self, fn, *args, **kwargs):
        super(PythonTask, self).__init__(None)
        self.fn = fn
        self.args = args
        self.kwargs = kwargs
        self.__progressHandler = PythonProgressHandler()

    def progressHandler(self):
        return self.__progressHandler

    def set_progress_handler(self, handler: PythonProgressHandler):
        self.__progressHandler = handler

    def run_impl(self, fn, *args, **kwargs):
        return fn(*args, **kwargs)

    def onStart(self):
        self.__progressHandler.started.emit()
        try: 
            result = self.run_impl(self.fn, *self.args, **self.kwargs) 
            self.__progressHandler.setResult(result)
        except:
            traceback.print_exc()
            exctype, value = sys.exc_info()[:2]
            self.__progressHandler.pythonError.emit((exctype, value, traceback.format_exc()))
        finally:
            self.__progressHandler.finished.emit()
            self.__progressHandler.tryFinishFromPython()


class ManageablePythonTask(PythonTask):
    """
    Добавляет PythonProgressHandler первым аргументом при вызове 
    пользовательской функции. Таким образом пользотель может 
    управлять прогрессом или обработать отмену операции
    """
    def __init__(self, fn, *args, **kwargs):
        super(ManageablePythonTask, self).__init__(fn, *args, **kwargs)

    def run_impl(self, fn, *args, **kwargs):
        return fn(self.progressHandler(), *args, **kwargs)
