from axipy import *
from PySide2.QtWidgets import QAction
from PyQt5.QtCore import QTimer


class Plugin:
    def __init__(self, iface):
        self.action = None
        self.menu = None
        self.notifications = iface.notifications
        self.timer = QTimer()
        self.timer.setInterval(1000)
        self.timer.start()
        self.timer.timeout.connect(self.init_menu)

    def init_menu(self):
        from axipy.app import mainwindow
        if mainwindow.is_valid:
            actName = "TmsDataProviderMenuAction"
            actions = mainwindow.qt_object().findChildren(QAction, actName)
            if (len(actions)):
                self.menu = actions[0].menu()
                self.action = self.menu.addAction('Публичная кадастровая карта')
                self.action.triggered.connect(self.show_map)
                self.timer.stop()
            else:
                print('Действие {} не найдено'.format(actName))

    def unload(self):
        if self.action is not None:
            self.menu.removeAction(self.action)

    def show_map(self):
        self.notifications.push ('Предупреждение', 'Отрисовка данных кадастровой карты на некоторых масштабах может производиться с временной задержкой.')

# Подложка
        prj_mercator = 'CoordSys Earth Projection 10, 104, "m", 0 Bounds (-20037508.34, -20037508.34) (20037508.34, 20037508.34)'
        osm_raster = provider_manager.tms.open('http://maps.axioma-gis.ru/osm/{LEVEL}/{ROW}/{COL}.png', prj=prj_mercator, watermark='<a href="https://axioma-gis.ru/articles/osm">© ESTI</a> <a href="https://www.openstreetmap.org/copyright">© OpenStreetMap</a>')
        osm_raster.name = 'osm'
        osm_layer = Layer.create(osm_raster)
        osm_layer.title = 'Подложка OSM'
		
# Зоны
        zones = provider_manager.rest.open('https://pkk.rosreestr.ru/arcgis/rest/services/PKK6/ZONES/MapServer')
        zones.name = 'zones'
        zones_layer = Layer.create(zones)
        zones_layer.zoom_restrict = True
        zones_layer.min_zoom = 30000
        zones_layer.title = 'Зоны'

# Кадастровое деление
        cadastre = provider_manager.tms.open('https://pkk.rosreestr.ru/arcgis/rest/services/Hosted/caddivsion/VectorTileServer/tile/{LEVEL}/{COL}/{ROW}.pbf',
           size=(1024, 1024), watermark='<a href="http://rosreestr.ru/">© Росреестр</a>')
        cadastre.name = 'cadastre'
        cadastre_layer = Layer.create(cadastre)
        cadastre_layer.title = 'Кадастровое деление'

# Границы
        borders = provider_manager.tms.open('https://pkk.rosreestr.ru/arcgis/rest/services/Hosted/borders/VectorTileServer/tile/{LEVEL}/{COL}/{ROW}.pbf',
           size=(1024, 1024), watermark='<a href="http://rosreestr.ru/">© Росреестр</a>')
        borders.name = 'borders'
        borders_layer = Layer.create(borders)
        borders_layer.visible = False
        borders_layer.title = 'Границы'

# Земельные участки 15-
        cadastre_objects = provider_manager.rest.open('https://pkk.rosreestr.ru/arcgis/rest/services/PKK6/CadastreObjects/MapServer')
        cadastre_objects.name = 'CadastreObjects'
        cadastre_objects_layer = Layer.create(cadastre_objects)
        cadastre_objects_layer.title = 'Земельные участки'

# Границы
        borders_gkn = provider_manager.rest.open('https://pkk.rosreestr.ru/arcgis/rest/services/PKK6/BordersGKN/MapServer')
        borders_gkn.name = 'BordersGKN'
        borders_gkn_layer = Layer.create(borders_gkn)
        borders_gkn_layer.title = 'Границы кадастра недвижимости'

        map = Map([ cadastre_objects_layer, borders_layer, cadastre_layer, borders_gkn_layer, zones_layer, osm_layer ])
        mapview = view_manager.create_mapview(map)
        mapview.coordsystem = CoordSystem.from_prj('Earth Projection 10, 104, "m", 0')
        mapview.center = Pnt(4187951, 7474203)
        mapview.set_zoom(500000)
