import axioma.gui.extension
import axioma.app
from PyQt5.QtWidgets import QMessageBox, QAction
from PyQt5.QtGui import QIcon
import PyQt5.QtCore
from PyQt5.QtCore import QCoreApplication

def set_center(widget, parent=None):
    if not parent:
        return
    center=parent.frameGeometry().center()
    frame=widget.frameGeometry()
    frame.moveCenter(center)
    widget.move(frame.topLeft())
    widget.setWindowModality(PyQt5.QtCore.Qt.WindowModal)
    widget.setParent(parent, PyQt5.QtCore.Qt.Dialog)

def slot():
    from .mainwindow import MainWindow
    m = MainWindow()
    set_center(m, axioma.app.mainWindow)
    from .converter import convert

    def convert_slot(input_file, output_file):
        try:
            convert(input_file, output_file)
            QMessageBox.information(m, QCoreApplication.translate("pen","Выполнено"), QCoreApplication.translate("pen","Конвертация проведена успешно"))
        except OSError as err:
            QMessageBox.critical(m, QCoreApplication.translate("pen","Ошибка"), str(err))
        except:
            QMessageBox.critical(m, QCoreApplication.translate("pen","Ошибка"), QCoreApplication.translate("pen","Неизвестная ошибка"))

    m.convert_request.connect(convert_slot)
    m.show()
 
def createAction(parent):
    action = QAction(parent)
    action.setText(QCoreApplication.translate("pen","Конвертер линий"))
    action.setIcon(QIcon(":/icons/share/32px/run3.png"))
    action.triggered.connect(slot);
    return action

def createMyExtensions():
    # Расширение, которое добавлят вкладку и группу кнопок в ленточный интерфейс Аксиомы.ГИС
    # Extension to append new tab and grop of buttons into ribbon of Axioma.GIS
    ribbonExt = axioma.gui.extension.RibbonExtension()
    ribbonExt.addTab("esti.utilities.tabid", QCoreApplication.translate("pen","Утилиты"))
    ribbonExt.addGroup("esti.utilities.tabid","esti.aux.groupid", QCoreApplication.translate("pen","Вспомогательные"))
    ribbonExt.addCategory("esti.utilities.catid", QCoreApplication.translate("pen","Утилиты"))
    # Задаём размер 2x2 ячейки
    # Set size of cell as 2x2
    ribbonExt.addAction("esti.pen_converter.actionid", "esti.utilities.tabid", "esti.aux.groupid",rowSpan=2, columnSpan=2)
    # Расширение, добавляющее QAction, создаваемое функцией createAction
    # Extension to add QAction created by createAction function
    actionExt = axioma.gui.extension.ActionExtension(createAction, "esti.pen_converter.actionid", QCoreApplication.translate("pen","Утилиты"))
    return [ribbonExt, actionExt]
