import os
from PyQt5.QtWidgets import QWidget, QFileDialog, QMessageBox
from PyQt5.uic import loadUi
from PyQt5.QtCore import pyqtSignal
from PyQt5.QtCore import QCoreApplication, QDir

class MainWindow(QWidget):
    convert_request = pyqtSignal(str, str)

    def __init__(self, parent=None):
        super().__init__(parent)
        cwd = os.path.dirname(__file__)
        self.__ui = loadUi(os.path.join(cwd, "mainwindow.ui"), self)
        self.__ui.btnOpen.clicked.connect(self.on_open_file_clicked)
        self.__ui.btnSave.clicked.connect(self.on_save_dir_clicked)
        self.__ui.btnConvert.clicked.connect(self.on_convert_clicked)
        # init ui
        self.__input_file = None
        self.__output_dir = None

    def set_input_file(self, input_file):
        self.__input_file = input_file
        self.__ui.leOpen.setText(input_file)

    def set_output_dir(self, output_dir):
        self.__output_dir = output_dir
        self.__ui.leSave.setText(output_dir)

    def on_open_file_clicked(self):
        result, _ = QFileDialog.getOpenFileName(self, QCoreApplication.translate("pen","Открыть стили линий MapInfo ..."),
                                                self.__input_file,
                                                filter=QCoreApplication.translate("pen","Стили линий MapInfo (*.pen)"))
        if result:
            self.set_input_file(result)

    def on_save_dir_clicked(self):
        result = QFileDialog.getExistingDirectory(self, QCoreApplication.translate("pen","Сохранить в ..."),
                                                  self.__output_dir)
        if result:
            self.set_output_dir(result)

    def on_convert_clicked(self):
        if not (self.__input_file and self.__output_dir):
            QMessageBox.critical(self, QCoreApplication.translate("pen","Ошибка"), QCoreApplication.translate("pen","Входные/выходные данные не заданы"))
            return
        if len(QDir(self.__output_dir).entryList(["*.trtp",], QDir.Files)):
            answer=QMessageBox.question(self, QCoreApplication.translate("pen","Предупреждение"), QCoreApplication.translate("pen",'Папка "{}" уже содержит файлы TRTP. Перезаписать?').format(self.__output_dir))
            if (answer != QMessageBox.Yes):
                return
        self.convert_request.emit(self.__input_file, self.__output_dir)


if __name__ == "__main__":
    from PyQt5.QtWidgets import QApplication

    app = QApplication(list())
    m = MainWindow()
    from converter import convert

    def convert_slot(input_file, output_file):
        try:
            convert(input_file, output_file)
            QMessageBox.information(m, "Выполнено", "Конвертация проведена успешно")
        except OSError as err:
            QMessageBox.critical(m, QCoreApplication.translate("pen","Ошибка"), str(err))
        except:
            QMessageBox.critical(m, QCoreApplication.translate("pen","Ошибка"), QCoreApplication.translate("pen","Неизвестная ошибка"))

    m.convert_request.connect(convert_slot)
    m.show()
    app.exec()
