"""Сервисные классы."""


from axipy.decorator import InitOnce
from axipy.utl.pnt import Pnt
from axipy.utl.rect import Rect
from PySide2.QtCore import QLocale


# fix sphinx inheritance and typehints
from axipy._util import fixup_module_metadata
fixup_module_metadata(__name__, globals())
del fixup_module_metadata

class Printer:
    """Класс для преобразования чисел с плавающией точкой в текст"""

    @staticmethod
    @InitOnce
    def _printer():
        from axipy.cpp_core_core import ShadowPrinter
        return ShadowPrinter()

    @staticmethod
    def to_localized_string(value: float, locale: QLocale = QLocale()) -> str:
        """
        Возвращает число в виде строки форматированный с учётом переданной локали.

        Args:
            value: Значение которое нужно представить в виде стоки.
            precision: Необходимое число знаков после запятой.
            locale: Локаль в которой нужно вывести значение. По умолчанию текущая локаль.
        """
        return Printer._printer().to_localized_string(value, locale)

    @staticmethod
    def to_localized_string_round(value: float, precision: int, \
        locale: QLocale = QLocale()) -> str:
        """
        Возвращает число в виде строки. Колличество знаков после запятой задаётся
        параметром precision.

        Args:
            value: Значение которое нужно представить в виде стоки.
            precision: Необходимое число знаков после запятой.
            locale: Локаль в которой нужно вывести значение. По умолчанию текущая локаль.
        """
        return Printer._printer().to_localized_string_round(value, precision, locale)
