from .data_provider import DataProvider, Table
from .source import Source, Destination, Schema
from typing import List, Optional


class SvgSource(Source):
    pass


class SvgDataProvider(DataProvider):
    """Провайдер для SVG.
    """
    _identifier = 'SvgDataProvider'

    def get_source(self, data: str) -> Source:
        """ Создает источник данных

        Args:
          data: Имя файла или описание источника данных.
        """
        return SvgSource(
            Source._provider(self.id),
            {
                'src': data
            }
        )
