from .data_provider import DataProvider, Table
from .source import Source, Destination, Schema
from typing import List, Optional


class OgrSource(Source):
    pass

class OgrDataProvider(DataProvider):
    """Провайдер для векторных данных OGR."""
    _identifier = 'OgrDataProvider'

    def get_source(self, data: str, dataobject: str) -> Source:
        """Создает источник данных

        Args:
          data: Источник данных или имя файла.
          dataobject: Наименование таблицы
        """
        return OgrSource(
            Source._provider(self.id),
            {
                'src': data,
                'dataobject': dataobject
            }
        )

    def file_extensions(self) -> List[str]:
        return list(filter(lambda v: v not in ['shp', 'shz'], super().file_extensions()))
