from .data_provider import DataProvider, Table
from .source import Source, Destination, Schema
from typing import List, Optional


class RestSource(Source):
    pass


class RestDataProvider(DataProvider):
    """Провайдер для ArcGIS REST.
    """
    _identifier = 'RestDataProvider'

    def get_source(self, url: str, fmt: str = 'png32', imageSR: str = 'imageSR', size: str = '1024*1024',
                   dpi: int = 96, transparent: str = 'true', layers: str = '') -> Source:
        """ Создает источник данных

        Args:
          url: Базовый URL.
          fmt: Формат выходного растра.
          imageSR: Код EPSG для выходного растра.
          size: Размер тайлов.
          dpi: DPI.
          transparent: Прозрачность выходного растра.
          layers: Перечень слоев.
        """
        return RestSource(
            Source._provider(self.id),
            {
                'src': url,
                'format': fmt,
                'imageSR' : imageSR,
                'size' : size,
                'dpi' : dpi,
                'transparent' : transparent,
                'layers' : layers
            }
        )
