
from axioma.gui import ProgressSpec, generateProgressDialog
from axioma.core import ( ProgressHandler, PythonProgressHandler, \
    ManageablePythonTask, TaskThreadPool )

def showLongWait(spec: ProgressSpec, fn, *args, **kwargs):
    """
    Запускает операцию в отдельном потоке и поднимает диалог отображающий
    прогресс. Тип диалога зависит от флага из перечисления ProgressSpec.
    В пользовательскую функцию первым аргументом передаётся обработчик 
    PythonProgressHandler.
    """
    task = ManageablePythonTask(fn, *args, **kwargs)
    handler = task.progressHandler()
    dialog = generateProgressDialog(handler, spec)
    TaskThreadPool.globalInstance().start(task)
    if handler.isFinished():
        return handler.result()
    dialog.exec_()
    return handler.result()
    

