'''

Пример пакетной загрузки локальных таблиц в СУБД.
Загружается как расширение. 

Последовательность действий:
1. Выбираем активное подключение куда будем производить экспорт. Если список пуст, необходимо его открыть (СУБД/Новое соединение с СУБД)
2. Добавляем файлы из файловой системы.
3. Устанавливаем дополнительные параметры
4. Производим экспорт


dependencies:
MainWindow
'''

from PyQt5.QtWidgets import QDockWidget
from PyQt5.QtGui import QIcon
from PyQt5.QtCore import Qt

import axioma.app
from axioma.core.dp import DataCatalog

class DockExtension(axioma.core.plugin.Extension):
    def __init__(self):
        super().__init__()
        self.mainWindow = self.createDependencyGetter(axioma.app.MainWindow)

    def onResolved(self):
     try:
        from .exportToDatabaseWidget import ExportToDatabaseWidget
        widget = ExportToDatabaseWidget(self.mainWindow().dataCatalog(), self.mainWindow())
        dock = QDockWidget("Экспорт в БД", self.mainWindow())
        dock.setWidget(widget)
        self.mainWindow().addDockWidget(Qt.RightDockWidgetArea, dock)
        self.mainWindow().addPanel(dock)
     except Exception as ex:
        print(ex)

def createExtensions():
    return [DockExtension()]
