from .data_provider import DataProvider, Table
from .source import Source, Destination, Schema
from typing import List


class CsvSource(Source):
    pass


class CsvDestination(Destination):
    pass


class CsvDataProvider(DataProvider):
    """Файловый провайдер: Текст с разделителями."""
    _identifier = 'CsvDataProvider'

    def get_source(self, filepath: str, with_header: bool = True,
                   delimiter: str = ',', encoding: str = 'utf8') -> Source:
        """Создает источник данных.

        Args:
            filepath: Путь к файлу.
            with_header: Признак того, что в первой строке содержатся имена
                атрибутов таблицы.
            delimiter: Разделитель полей.
            encoding: Кодировка.
        """
        return CsvSource(
            Source._provider(self.id),
            Source._table_file(filepath),
            {
                'delimiter': delimiter,
                'hasNamesRow': with_header,
                'charset': encoding
            }
        )

    def get_destination(self, filepath: str, schema: Schema, with_header: bool = True,
                        delimiter: str = ',', encoding: str = 'utf8') -> Destination:
        """Создает назначение объекта данных.

        Args:
            filepath: Путь к файлу.
            schema: Схема таблицы.
            with_header: Признак того, что в первой строке содержатся имена
                атрибутов таблицы.
            delimiter: Разделитель полей.
            encoding: Кодировка.
        """
        return CsvDestination(schema,
                              Source._provider(self.id),
                              Source._table_file(filepath),
                              {
                                  'delimiter': delimiter,
                                  'hasNamesRow': with_header,
                                  'charset': encoding
                              }
                              )
