#!/usr/bin/python3
# -*- coding: utf-8 -*-

# Импорт
from axioma.render import *
from axioma.core.sql import *
from axioma.mapinfo import *
from axioma.core.plugin import *

from PyQt5.QtCore import QObject, Qt
from PyQt5.QtGui import *

import axioma.app
import axioma.gui

"""
Примеры создания тематических слоев в окне карты
Перед запуском скрипта необходимо открыть карту со слоем world.
"""

# Создание переменной для обеспечения возможности вычисления выражений
runtime = SqlRuntime()

# Создание выражения по полю
def makeExpressionForWorld(layer, attr):
    evaluator = FeatureExpressionEvaluator(runtime, layer.tableSchema())
    if not evaluator.setExpression(axioma.app.mainWindow.tr(attr)):
        print(evaluator.errorString())
    return evaluator
    
# Добавление слоя в конец списка
def addLayer(layer, thematic):
    layer.appendLayer(thematic);

# Интервалы
def addRangeThematic(layer):
    print("Range thematic..." )
    rangeLayer = RangeThematicLayer(layer) # Создание самого слоя
    rangeStyleProvider =  RangeThematicStyleProvider(rangeLayer) # Стиль оформления
    evaluator = makeExpressionForWorld(layer, QObject().tr("Население"))
    if not evaluator.hasError():
        rangeStyleProvider.setEvaluator(evaluator);
        rangeStyleProvider.setTypeSplitting(RangeThematicStyleProvider.TS_EQUAL_COUNT);
        rangeStyleProvider.initValuesFromTable( layer.table()) # чтение из таблицы
        rangeStyleProvider.setColorMin(Qt.red) # цвет минимума
        rangeStyleProvider.setBreakParameters(Qt.green, 6) # Разрыв по цвету
        rangeStyleProvider.setColorMax(Qt.yellow) # цвет максимума
        rangeStyleProvider.initIntervals(12); # Количество интервалов
        rangeStyleProvider.splitValuesToIntervals() # Разбиение полученых значений по интервалам
        rangeLayer.setStyleProvider(rangeStyleProvider)  # Установка провайдера стиля
        addLayer(layer, rangeLayer)

def colorToMapbasic(color):
    return QColor(color).rgb() - 0xFF000000

# Интервалы с явным указанием параметров каждого интервала

def addRangeThematicManual(layer):
    print("Range manual range thematic..." )
    rangeLayer = RangeThematicLayer(layer) # Создание самого слоя
    rangeStyleProvider =  RangeThematicStyleProvider(rangeLayer) # Стиль оформления
    evaluator = makeExpressionForWorld(layer, QObject().tr("Население"))
    if not evaluator.hasError():
        rangeStyleProvider.setEvaluator(evaluator);
        rangeStyleProvider.setTypeSplitting(RangeThematicStyleProvider.TS_EQUAL_COUNT);
        rangeStyleProvider.initValuesFromTable( layer.table()) # чтение из таблицы
# Явно устанавливаем интервалы и соотвествующие им стили      
        style1 = MapBasicStyle().styleFromString("Pen (1, 2, 0) Brush (2, %d)"  % ( colorToMapbasic(Qt.red)))
        style2 = MapBasicStyle().styleFromString("Pen (1, 2, 0) Brush (2, %d)"  % ( colorToMapbasic(Qt.blue)))
        style3 = MapBasicStyle().styleFromString("Pen (1, 2, 0) Brush (2, %d)"  % ( colorToMapbasic(Qt.green)))
        p1 = ThematicRangeStyleParam(0, 1326796, style1)
        p2 = ThematicRangeStyleParam(1326796, 8954000, style2)
        p3 = ThematicRangeStyleParam(8954000, 1130510638, style3)
        pars = [p1, p2, p3] # Массив с параметрами интервалов
        rangeStyleProvider.setThematicStyleParamsList(pars)
        rangeLayer.setStyleProvider(rangeStyleProvider)  # Установка провайдера стиля
        rangeLayer.setName('Интервалы по параметрам')
        addLayer(layer, rangeLayer)
    
# Создание пар стиль - выражение
def makeStylePair(layer, color, attr):
    style = polygonStyleForColor(color)
    expr = makeExpressionForWorld(layer, attr)
    return ThematicColorExpressionParam(style, expr)

# Создание списка выражений по цветам
def makeExpressionListForWorld(layer):
    list = []
    list.append(makeStylePair(layer, Qt.red, QObject().tr("Население")))
    list.append(makeStylePair(layer, Qt.blue, QObject().tr("Pop_Male")))
    list.append(makeStylePair(layer, Qt.green, QObject().tr("Pop_Fem")))
    return list
    

# Круговая диаграмма
def addPieThematic(layer):
    print("Pie thematic..." )
    pieLayer = PieThematicLayer(layer)
    pieStyleProvider =  PieThematicStyleProvider(pieLayer)
    pieStyleProvider.setStartAngle(30)
    pieStyleProvider.setExpressions(makeExpressionListForWorld(layer)) # Установим выражения
    if len(pieStyleProvider.thematicColorExpressionParams()) > 1:
        sizeParam = pieStyleProvider.sizeParam() 
        sizeParam.sumValue = pieStyleProvider.calculateMaxSum(layer.table()) # максимальное значение
        sizeParam.mapScale = 160000000 # для масштаба
        sizeParam.diameter = UnitValue(Unit.cm(), 1.0) # размер в сантиметрах
        pieStyleProvider.setSizeParam(sizeParam)
        pieLayer.setStyleProvider(pieStyleProvider)  # Установка провайдера стиля
        addLayer(layer, pieLayer)
    
# Столбчатая диаграмма
def addBarThematic(layer):
    print("Bar thematic..." )
    barLayer = BarThematicLayer(layer)
    barStyleProvider =  BarThematicStyleProvider(barLayer)
    barStyleProvider.setExpressions(makeExpressionListForWorld(layer)) # Установим выражения
    if len(barStyleProvider.thematicColorExpressionParams()) > 1:
        barStyleProvider.setIsStacked(True) # Стопкой
        barStyleProvider.setAllocationType(AllocationThematic.AT_LINEAR) # Распределение значений
        sizeParam = barStyleProvider.sizeParam() 
        sizeParam.value = barStyleProvider.calculateMaximum(layer.table()) # максимальное значение
        sizeParam.mapScale = 160000000 # для масштаба
        sizeParam.diameter = UnitValue(Unit.cm(), 1.0) # размер в сантиметрах
        barStyleProvider.setSizeParam(sizeParam)
        barLayer.setStyleProvider(barStyleProvider)  # Установка провайдера стиля
        addLayer(layer, barLayer)

# Символы
def addSymbolThematic(layer):
    print("Symbol thematic..." )
    symbolLayer = SymbolThematicLayer(layer) # Создание самого слоя
    symbolStyleProvider =  SymbolThematicStyleProvider(symbolLayer) # Стиль оформления
    evaluator = makeExpressionForWorld(layer, QObject().tr("Население"))
    if not evaluator.hasError():
        symbolStyleProvider.setEvaluator(evaluator);
        limitsValues = symbolStyleProvider.calculateLimitsValues( layer.table()) # Расчет предельных значений
        symbolStyleProvider.setLimitsValues(limitsValues)
        fs = FontSymbolStyle()
        fs.setColor(Qt.red)
        symbolStyleProvider.setDefaultStyle(fs) # Стиль точечного объекта
        symbolStyleProvider.setMaxHeight(24) # Максимальная высота символа
        symbolLayer.setStyleProvider(symbolStyleProvider)  # Установка провайдера стиля
        addLayer(layer, symbolLayer)


# Объявляем класс-расширение для получения менеджера стилей
class MyExtension(axioma.core.plugin.Extension):
    def __init__(self):
        super().__init__()
        self.styleManager = self.createDependencyGetter(axioma.render.GeometryStyleManager)

# Создаем расширение как объект и регистрируем его в системе
ext = MyExtension()
axioma.app.gui.prependExtension(ext)


# Индивидуальные значения
def addIndividualThematic(layer):
    print("Individual thematic..." )
    individualLayer = IndividualThematicLayer(layer) # Создание самого слоя
    individualLayer.setName(QObject().tr("Континенты по цветам")) # Имя слоя
    individualStyleProvider =  IndividualThematicStyleProvider(individualLayer) # Стиль оформления
    evaluator = makeExpressionForWorld(layer, QObject().tr("Континент"))
    if not evaluator.hasError():
        individualStyleProvider.setEvaluator(evaluator)
        individualStyleProvider.initValuesFromTable( layer.table()) # чтение из таблицы
        individualStyleProvider.reallocateColorByValues()
        if individualStyleProvider.thematicStyleParamCount(): # Заменим у первого цвет на желтый
            param0 = individualStyleProvider.thematicStyleParam(0) 
            param0.setColor(Qt.yellow)
            individualStyleProvider.setThematicStyleParam( 0, param0)
        if individualStyleProvider.thematicStyleParamCount() > 1: # Заменим у второго стиль на строку MapBasic
            param1 = individualStyleProvider.thematicStyleParam(1)
            # Создаем стиль из строки MapBasic
            style = MapBasicStyle().styleFromString("Brush (8,16776960,16777215) Pen (1,2,0)")
            # Через менеджер расширений получаем нужное расширение для заданного стиля
            styleExt = axioma.app.render.geometryStyleManager().styleExtensionByStyle(style)
            # Заменяем стиль
            param1.style().setStyle(styleExt.geometryStyleClassId(), style)
            # Если без использования расширения можно явно указать стиль типа объекта
            # param1.style().setStyle(PolygonalGeometryClass(), style)
            individualStyleProvider.setThematicStyleParam( 1, param1)
        individualLayer.setStyleProvider(individualStyleProvider)  # Установка провайдера стиля
        addLayer(layer, individualLayer)

# Тематический слой по плотности точек
def addDensityThematic(layer):
    print("Density thematic..." )
    densityLayer = DensityThematicLayer(layer) # Создание самого слоя
    densityStyleProvider =  DensityThematicStyleProvider(densityLayer) # Стиль оформления
    evaluator = makeExpressionForWorld(layer, QObject().tr("Население"))
    if not evaluator.hasError():
        densityStyleProvider.setEvaluator(evaluator);
        maxVal = densityStyleProvider.calculateMaximum( layer.table()) # Максимальное значение
        densityStyleProvider.setDensitySizeParam(DensitySizeParam(100, maxVal)) # 100 точек для максимального значения
        styleParam = DensityStyleParam(DensityStyleParam.ftRound, Qt.red, UnitSize(Unit.point(), 3)) # Круглые красные точки в 3 пикселя
        densityStyleProvider.setDensityStyleParam(styleParam)
        densityLayer.setStyleProvider(densityStyleProvider) # Установка провайдера стиля
        addLayer(layer, densityLayer)

isFound = False

for mapview in axioma.app.mainWindow.mapViewManager().mapViews():
    layer = mapview.rootLayerGroup().findChildByName("world")
    if layer is not None:
        isFound = True
        addDensityThematic(layer)
        addSymbolThematic(layer)
        addPieThematic(layer)
        addBarThematic(layer)
        addRangeThematic(layer)
        addRangeThematicManual(layer)
        addIndividualThematic(layer)
        print("Count of layers: %d" % layer.thematicLayerGroup().childCount())
        break

if not isFound:
    print("Слой world не найден")
