# Функция create_from_json используется для создания таблицы
# В настоящий момент поддерживается только создание таблицы в формате MapInfo TAB
# В параметре ``src`` задается расположение TAB-файла
# В параметре ``spec`` задается спецификация схемы таблицы в виде массива атрибутов.
# Для каждого из атрибутов указываются параметры ``name`` и ``type`` (для геометрии параметр ``name`` не используется)
# Возможные значения параметра ``type``: string,int,int16,int64,double,decimal,bool,date,time,datetime,geometry
# Для атрибутов типа ``string`` должен быть задат параметр ``length`` (длина)
# Для атрибутов типа ``decimal`` должны быть заданы параметры ``length`` и ``precision`` (длина и точность)
# Для атрибутов типа ``geometry`` координатная система задаётся в параметре ``prj``

# Пример создания таблиц на базе из описания в формате json:

import axioma
import axioma.core

json = {
    "src": "/tmp/test.tab",
    "spec": [
        {"name": "CITY", "type": "string", "length": 20},
        {"name": "COUNTRY", "type": "string", "length": 30},
        {"type": "geometry", "prj": "CoordSys Earth Projection 26, 28, 7, 0, 60"}
    ]
}
t = axioma.core.create_from_json(json)
axioma.app.mainWindow.registerDataObject(t)


# Указание КС в формате EPSG
json2 = {
    "src": "/tmp/test2.tab",
    "spec": [
        {"name": "CITY", "type": "string", "length": 20},
        {"type": "geometry", "prj": "epsg:4284"}
    ]
}
t2 = axioma.core.create_from_json(json2)
axioma.app.mainWindow.registerDataObject(t2)
