import axioma.app
from PyQt5.QtCore import QRectF, QPointF

'''
Пример создания окна карты и таблицы просмотра в главном окне приложения
'''

# Открываем таблицу
table = axioma.core.open_json({"src" : "/tmp/world.tab"})
# Если нужно, чтобы пользователь видел таблицу в списке открытых данных,
# добавляем её в каталог приложения
axioma.app.mainWindow.dataCatalog().addDataObject(table) 
# Создаём слой для таблицы
layer = axioma.app.render.createLayerForDataObject(table)
# Создаём окно карты и показываем его в главном окне
mapView = axioma.app.mainWindow.createMapViewForLayerList([layer], 'Моя карта')
#
# Попробуем заменить координатную систему для карты, если нам это необходимо.
# Текущую КС карты можно взять так: mapView.viewport().coordSystem()
# КС таблицы можно взять так: table.coordSystem()
# Или создать с помощью CoordSysFactory:
cs = axioma.app.csfactory.createFromEpsg(4326);
# Задаем новую область отображения:
rect_cs = cs.rectNumericCoordSys()
rect_device = QRectF(mapView.rect())
rect_cs.setHeight(rect_cs.width() / ( rect_device.width() / rect_device.height())) # пропорционально размеру окна виджета
viewport = axioma.render.MapViewport(rect_device, rect_cs, cs)
# Устанавливаем область отображения для карты
mapView.setViewport(viewport)
# Показываем таблицу в виде списка
axioma.app.mainWindow.showTableData(table)
