import axioma
import axioma.core.dp
import axioma.core.geometry

'''
Добавление в окно карты на косметический слой точки со стилем по умолчанию.
Перед запуском необходимо открыть карту
'''

# список всех окон Карт
map_view_list=axioma.app.gui.widgetManager.allWidgets(axioma.gui.MapView.staticMetaObject)

if len(map_view_list):
    # берем первую карту из полученного списка
    map_view=map_view_list[0]
    cosmetic_table=map_view.cosmeticLayer().table()
    coord_system=map_view.viewport().coordSystem()
    # создаем новую пустую запись
    new_feature=axioma.core.dp.Feature.createFeature(cosmetic_table.tableSchema())
    # задаем геометрию и стиль
    geometry_index=new_feature.geometryIndex()
    style_index=new_feature.styleIndex()
    point=axioma.core.geometry.Point(coord_system, 0, 0)
    new_feature.setAttribute(geometry_index, point)
    # стиль по умолчанию для точечных объектов
    point_style=axioma.app.render.styleService().newObjectStyle().style(point)
    new_feature.setAttribute(style_index, point_style)
    new_feature.setAllModified(True)
    # вставка
    cosmetic_table.insert([new_feature], "add Point(0, 0)")
