
import os
import sys
import axioma
from axioma.core import open_json, ManageablePythonTask
import axioma.core.geometry as gm
from axioma.core import PythonProgressHandler, TaskThreadPool, Range
from PyQt5.QtCore import QThread, QThreadPool
from CustomProgressDialog import ConcurrentProgressDialog

# небольшая хитрость чтобы можно было положить данные в папку где лежит скрипт
# и ссылаться на них только по имени
dir_path = os.path.dirname(os.path.realpath(__file__))
sys.path.append(dir_path)

def connect_handler_to_progress_dialog(handler: PythonProgressHandler, \
    dialog: ConcurrentProgressDialog):
    dialog.canceled.connect(handler.tryCancelFromPython)
    # закрываем диалог только после того как завершиться задача
    handler.finished.connect(dialog.forceClose)
    def set_range_to_dialog(range: Range):
        dialog.set_progress_range(range.min, range.max)
    handler.progressRangeChanged.connect(set_range_to_dialog)
    handler.progressValueChanged.connect(dialog.set_value)
    handler.messageChanged.connect(dialog.set_main_message)
    handler.windowTitleChanged.connect(dialog.setWindowTitle)

class TaskSpec:
    """
    Класс контейнер для параметров, которыми инициализируем диалог
    с прогрессом
    """
    def __init__(self, title, parent, min=0, max=0):
        self.title = title
        self.parent = parent
        self.min = min
        self.max = max

def init_progress_dialog(dialog: ConcurrentProgressDialog, spec: TaskSpec):
    """
    Начальная инициализация диалога
    """
    dialog.setWindowTitle(spec.title)
    dialog.set_progress_range(spec.min, spec.max)
    dialog.setParent(spec.parent)
    dialog.setMinimumWidth(420)


def run_task_and_show_progress(spec: TaskSpec, fn, *args, **kwargs):
    """
    Обёртка которая выполняет за пользователя всю работу по запуску вычисления
    задачи, отображение диалога и тп
    """
    task = ManageablePythonTask(fn, *args, **kwargs)
    progressHandler = task.progressHandler()
    dialog = ConcurrentProgressDialog(axioma.app.mainWindow)
    init_progress_dialog(dialog, spec)
    connect_handler_to_progress_dialog(progressHandler, dialog)
    TaskThreadPool.globalInstance().start(task)
    if not progressHandler.isFinished():
        dialog.exec_()
    return progressHandler.result()

def user_heavy_function(progressHandler, json):
    """
    Пример пользовательской функции выполняющей длительные вычисления
    """
    table = open_json(json)
    features = table.allFeatures()  
    index_geo = table.tableSchema().geometryIndex()
    result = []
    # Устанавливаем границы изменения прогресса
    progressHandler.setProgressRange(0, len(features))
    progress = 0
    for feature in features: 
        # Тут мы проверяем не отменил ли пользователь операцию через интерфейс
        if progressHandler.isCanceled():
            return
        geom = feature.getAttribute(index_geo)
        if not gm.isValid(geom):
            geom = gm.normalizedGeometry(geom)
        result.append(gm.ConvexHull(geom))
        progress +=1
        # Управляем прогрессом, устанавливая текущее значение
        progressHandler.setProgress(progress)
        progressHandler.setMessage("Номер геометрии: {}".format(progress))
    return result

print("start")

json = {"src": dir_path + "/tab_file_name.tab"}
spec = TaskSpec("Получаем минимальный окаймляющий полигон", \
    axioma.app.mainWindow)
result = run_task_and_show_progress(spec, user_heavy_function, json)
if result:
    print("Количество геометрий: {}".format(len(result)))

print("finish")   