import axioma.gui.extension
from axioma.core.dp import ForeignKeyManagerExtension, JsonDefinition, JsonController, ForeignKey

'''
Пример создания ссылки на справочник для поля таблицы. Данный скрипт необходимо выполнить до открытия источников данных.
После выполнения открываем таблицу ElectricLine.tab. При этом таблица DIC_VOLTAGE.tab так-же будет открыта.
Далее в элементах редактирования атрибутивной информации таблицы ElectricLine значение поля VOLTAGE будет заменено выпадающим 
списком с текстовым описанием, взятом из справочника (значение поля ShortNAM).
'''

# Создаем расширение для храниния данных по внешним ключам.
foreignExt = axioma.core.dp.ForeignKeyManagerExtension()

# Описываем основную таблицу
jdTable = JsonDefinition()
JsonController.setSource(jdTable, '/tmp/ElectricLine.tab')
JsonController.setObject(jdTable, 'ElectricLine')

# Описываем таблицу-справочник
jdDict = JsonDefinition()
JsonController.setSource(jdDict, '/tmp/DIC_VOLTAGE.tab')
JsonController.setObject(jdDict, 'DIC_VOLTAGE')

# Данные по полям
keyFields = ForeignKey.FromTo()
# Атрибут с кодом основной таблицы
keyFields.attributeKey = 'VOLTAGE'
# Атрибут с кодом таблицы-справочника
keyFields.attributeKeyForeign = 'VOLTAGE'
# Атрибут с описанием в таблице-справочнике
keyFields.attributeNameForeign = 'ShortNAM'

# Регистрируем в расширении внешний ключ.
foreignExt.registerForeignKeyByData(jdTable, jdDict, keyFields)

# Регистрируем расширение в системе
axioma.app.core.prependExtension(foreignExt)
