import axioma.render
from axioma.common import RuntimeException
from axioma.core.dp import *
from PyQt5.QtCore import  *
from PyQt5.QtGui import QGuiApplication
import sys

'''
Пример экспорта таблицы в БД postgresql.
В базе должно присутствовать расширение postgis
'''

a = QGuiApplication(sys.argv)
render = axioma.render.Render()
render.initialize()

# Открываем исходную таблицу
table = axioma.core.open_json({'src': '/tmp/SubjectRF.TAB'})

try:
    if table is None:
        raise RuntimeException("Таблица не открыта")
# Находим необходимый провайдер. В данном случае PostgreSQL
    dataProvider = axioma.app.core.dataProviderById("PgDataProvider")
    if dataProvider is not None:
# Описание источника данных, куда будем производить экспорт
        dbDefinition = dataProvider.createDatabaseDefinition('localhost', 'esti', 'postgres', '')
# Параметры экспорта
        jd = JsonDefinition()
# Установка в параметрах описания источника подключения
        JsonDBExportController.setDbDef(jd, dbDefinition)
        tableName = '{}_export'.format(table.name())
# Наименование результирующей таблицы
        JsonDBExportController.setObject(jd, tableName)
# Координатная система
        JsonDBExportController.setPrj(jd, table.coordSystem())
# Дополнительные параметры (опционально)
        params = {
# Скрипт с успешно выполненными командами
            DatabaseProviderExportSupport.logFileTag: QDir.temp().filePath('export_success.sql'),
# Скрипт с ошибочными записями
            DatabaseProviderExportSupport.errorFileTag: QDir.temp().filePath('export_error.sql'),
# Наменование колонки с оформлением
            DatabaseProviderExportSupport.renditonColumnNameTag: 'mi_style',
# Наменование колонки с геометрией
            DatabaseProviderExportSupport.geometryColumnNameTag:'geometry',
# Предварительно удалять таблицу
            DatabaseProviderExportSupport.dropTableTag:True,
# Создавать пространственный индекс
            DatabaseProviderExportSupport.createIndexTag:True,
# Регистрация в таблице MAPINFO_MAPCATALOG
            DatabaseProviderExportSupport.mapCatalogTag:True,
# SRID с базе данных для проекции
            DatabaseProviderExportSupport.sridTag:4326
        }
# Устанавливаем дополнительные параметры
        JsonDBExportController.setExportParams(jd, params)
# Создаем контекст
        context = ProviderExportContext(ModifiedTableSchema(table.tableSchema()))
# Открывем запрос для исходной таблицы
        cursor = table.select(QuerySelectAll( table.tableSchema().attributeNames()))
# Производим экспорт. Если необходим отклик системы предлагаем использовать SignalingCursor
        dataProvider.exportFeatures(cursor, context, jd)
    else:
        raise RuntimeException("Провайдер не найден")
except Exception as ex:
    print(ex)

