from .data_provider import DataProvider, Table
from .source import Source, Destination, Schema
from typing import List, Optional


class GdalSource(Source):
    pass


class GdalDataProvider(DataProvider):
    """Провайдер для растров.
    """
    _identifier = 'GdalDataProvider'

    def get_source(self, data: str) -> Source:
        """ Создает источник данных
        data: Имя файла или описание источника данных.
        """
        return GdalSource(
            Source._provider(self.id),
            {
                'src': data
            }
        )
