"""Основной пакет API для взаимодействия с ГИС "Аксиома".

Предоставляет доступ к Аксиоме.ГИС через набор модулей, подмодулей,
классов и функций.

Attributes:
    io (axipy.da.ProviderManager):
        Объект открытия/создания объектов данных.

        Attention:
            Устарел в версии 3.0.0. Используйте готовый экземпляр :attr:`axipy.da.provider_manager`.
"""

# forward imports
from typing import Callable
from PySide2.QtWidgets import QApplication
import os.path
import sys
import os
from axipy.utl import *
from axipy.cs import *
from axipy.da import *
from axipy.da import providers
from axipy.sql import *
from axipy.render import *
from axipy.gui import *
from axipy import menubar
from axipy.menubar import Position

from axipy.core import *
from axipy.mi import *
from axipy.da import data_manager
from axipy.interface import *
from axipy.axioma_plugin import *
from axipy.cpp_app import ShadowApplication


io = provider_manager
data = provider_manager


def init_axioma() -> QApplication:
    """Инициализирует ядро ГИС "Аксиома".

    Returns:
        Приложение Qt5 c очередью событий (event-loop).

    Пример::

        app = init_axioma()
        app.exec_()  # запускает обработку очереди событий
    """
    global AXIOMA_CORE
    global APP
    from axipy.gui import gui_instance
    if gui_instance._is_initialized():
        AXIOMA_CORE = gui_instance
        APP = QApplication.instance()
    else:
        home_dir = os.environ['AXIOMA_HOME']
        os.chdir(home_dir)

        stdout = sys.stdout

        APP = QApplication(list())
        ShadowApplication.initialize(APP)
        AXIOMA_CORE = gui_instance
        AXIOMA_CORE._initialize()

        sys.stdout = stdout

    return APP
