# TableQuery demo
import axioma.core.dp as dp
import axioma.app
from PyQt5.QtCore import QRectF

def print_features_info(features):
    if not len(features):
        raise Exception("В таблице нет записей")
    print("Количество всех записей: %d" % len(features))
    feature = features[0]
    print("Все атрибуты первой записи: %s" % [str(feature.getAttribute(i)) for i in range(feature.numAttributes())])

window = axioma.app.mainWindow
tables = window.listTables()

print("=======%s=======" % "TableQuery demo")

if not len(tables):
    raise Exception("Не открыто ни одной таблицы")

table = tables[0]

print("Table name: %s; Attrs names: %s" % (table.name(), ", ".join(table.attributeNames())))

# SelectAll
print("Запрос всех записей:")

print("=======%s=======" % "Запрос всех аттрибутов")
query_select_all = dp.QuerySelectAll(table.attributeNames())
features = table.selectToFeatureList(query_select_all)
print_features_info(features)

# Fetch specific attributes
print("=======%s=======" % "Запрос не всех, конкретных атрибутов")
features = table.selectToFeatureList(dp.QuerySelectAll(table.attributeNames()[:2]))
print_features_info(features)

# Apply PageRange
print("=======%s=======" % "Использовать ограничение на количество записей")
print("Запросить 2 записи начиная со второй")
page_range = dp.PageRange(2, 2)
features = table.selectToFeatureList(dp.QuerySelectAll(table.attributeNames()), page_range)
print_features_info(features)

# TableQuery in GeoRect
print("Query features in GeoRect")
# допустим, проекция таблицы - Latlong
coord_system = table.coordSystem()
# Создадим прямоугольник
georect = dp.GeoRect(QRectF(-180, 0, 90, 90), coord_system)
features = table.selectFeaturesInMbr(georect, table.attributeNames())
print_features_info(features)

#  TableQuery by Id
print("=======%s=======" % "Query features by id")
# Восстановление; получение записей с полным количеством атрибутов
print("Например, из списка записей с усеченным набором атрибутов получим те же записи cо всеми атрибутами")
features = table.selectToFeatureList(dp.QuerySelectAll(table.attributeNames()[:3]), dp.PageRange(2, 2))
print_features_info(features)
full_features = table.selectFeaturesById([feature.id() for feature in features], table.attributeNames())
print_features_info(full_features)
