import axioma.render
#import axioma.cs as cs
from axioma.cs import *
from axioma.render import *
from axioma.core.dp import *

#from axioma.cs import *
from PyQt5.QtCore import  *
from PyQt5.QtSvg import  *

import sys

from PyQt5.QtGui import *

a = QGuiApplication(sys.argv)
render = axioma.render.Render()
render.initialize()

def createLayer(name):
    table = axioma.core.open_json({'src': name})
    return render.createLayerForDataObject(table)

try:
    baseCatalog = '/tmp/tab/'
    outCatalog = '/tmp/'
    layerWorld = createLayer(baseCatalog + 'world.tab')
    layerRusObl = createLayer(baseCatalog + 'rus_obl.tab')
    layerWorldcap = createLayer(baseCatalog + 'worldcap.tab')
    layerRail = createLayer(baseCatalog + 'railway.tab')

    if layerWorld is not None:
        props = layerWorld.featureLayerProperties()  # Свойства слоя
        props.setLabelingAttributeName('Country')  # устанавливаем выражение для метки
        props.setShowLabels(True)  # Показ меток
        layerWorld.setProperties(props)  # Устанавливаем новые свойства слоя

    br = layerWorld.boundingRect()  # rect слоя
    sceneRect = QRectF(br.left(), br.top(), br.width(), br.height())
    size = QSize(1000, 1000*br.height()/br.width())
    imRect = QRect(0, 0, size.width(), size.height())
    map = Map()  # временная карта
    # добавляем слои в карту
    map.rootLayerGroup().append(layerRail)
    map.rootLayerGroup().append(layerWorldcap)
    map.rootLayerGroup().append(layerRusObl)
    map.rootLayerGroup().append(layerWorld)
    viewport = MapViewport(QRectF(imRect), sceneRect, layerWorld.coordSystem())
# Вывод в image
    image = QImage(imRect.size(), QImage.Format_ARGB32_Premultiplied)  # Сам растр, куда будем рисовать
    image.fill(Qt.white)
    painter = QPainter(image)
    context = MapContext(painter, viewport)  # контекст, куда рисуем
#        layer.render(context)  # Отрисовка слоя
    renderer = ConcurrentMapRenderer()  # объект, занимающийся многопоточной отрисовкой
    renderer.blockingRender(map, context)  # отрисовка карты
    image.save(outCatalog + 'out_raster.png')  # Если мы хотим сохранить как растр в файловой системе
# Вывод в svg
    generator = QSvgGenerator()
    #generator.setResolution(101)
    generator.setFileName(outCatalog + 'out_vector.svg')
    generator.setSize(size);
    generator.setViewBox(QRect(QPoint(0, 0) , size));
    painter_svg = QPainter()
    painter_svg.begin(generator)
    context_svg = MapContext(painter_svg, viewport)  # контекст, куда рисуем
    vectorRenderer = VectorMapRenderer()
    vectorRenderer.render(map, context_svg)  # отрисовка карты

    #layerWorld.renderVector(context_svg) # Отрисовка слоя
    painter_svg.end()

except Exception as ex:
    print(ex)
