import sys
import axioma.gui.extension
import PyQt5.QtGui

'''
Пример создания кнопки на панели инструментов
'''

class SimpleActionExtension(axioma.gui.NativeActionExtension):
    def __init__(self, action_id,  description, icon, slot, ribbon_action_info, parent=None):
        super().__init__(action_id, ribbon_action_info, parent)
        self._slot = slot
        self._description = description
        self._icon = icon

    def customizeAction(self, action):
        action.setText(self._description)
        action.setIcon(self._icon)
        action.triggered.connect(self._slot);

def addTab(tabId, description): # Новая закладка
  ribbonExt = axioma.gui.extension.RibbonExtension()
  ribbonExt.addTab(tabId, description)
  axioma.app.gui.prependExtension(ribbonExt)
  
def addGroup(tabId, groupId, description): # Новая группа в интерфейсе
  ribbonExt = axioma.gui.extension.RibbonExtension()
  ribbonExt.addGroup(tabId, groupId, description)
  axioma.app.gui.prependExtension(ribbonExt)
    
def addAction(tabId, groupId, actonId): # Регистрация действия в интерфейсе
    ribbonExt = axioma.gui.extension.RibbonExtension()
    ribbonExt.addAction(actonId, tabId, groupId)
    axioma.app.gui.prependExtension(ribbonExt)
    
def createAction(actonId, description, icon, slot ): # Создание и регистрация действия в системе
    actionExt = SimpleActionExtension(actonId, description, icon, my_slot, axioma.gui.RibbonActionInfo())
    axioma.app.gui.prependExtension(actionExt)



def my_slot(): # эта функция будет вызываться по нажатию кнопки
    print('SLOT')

# создаем действие
createAction( "TestActionId", "Тестовое действие", PyQt5.QtGui.QIcon(":/icons/share/32px/run.png"), my_slot)
# Добавляем tab если это нужно
addTab("TestPluginTab", "Тестовый модуль")
# Добавляем группу
addGroup("TestPluginTab", "TestGroupId", "Тестовая группа")
# Добавляем action (да, кнопку, да)
addAction("TestPluginTab", "TestGroupId", "TestActionId")

