import axioma.core
from axioma.core.dp import *

'''
Пример подключения прогресса при перемещении по записям курсора.
После 10-й записи прерываем выполнение.
'''

table = axioma.core.open_json({'src': '/tmp/world.tab'})
if not table:
	raise RuntimeError("Нет открытых таблиц")
cursor=table.select(QuerySelectAll(table.attributeNames())) # Запрашиваем все данные и открывем курсор
signaling_cursor=SignalingCursor(cursor) # Оборачиваем курсор

def local_slot(count): # Функция выполняется при итерации по строкам до значения 10
	print("Запись -->"+str(count))
	if count >= 10:
		print("Прервано на итерации #10")
		signaling_cursor.abort() # Прерывание выполнения

signaling_cursor.moved.connect(local_slot) # Подключаем функцию к событию перемещения на другую строку курсора
for feature in signaling_cursor:
	print(feature.getAttribute(0))
