from axioma.cs import *
from axioma.core.geometry import *
from axioma.mapinfo import *
from axioma.render import *

from PyQt5.QtCore import  QRectF, Qt
from PyQt5.QtGui import QImage, QPainter

'''
Отрисовка точки со стилем в растровый файл. При этом точка, находящаяся в середине прямоугольника ((-250, -250) (250, 250) ),
отрисовывается по центру растра размером 100*100.
'''

import axioma.render
from PyQt5.QtGui import *
import sys

a = QGuiApplication(sys.argv)
render = axioma.render.Render()
render.initialize()

rect_scene = QRectF(-250,-250,500,500) # Прямоугольник сцены (карты)
rect_device = QRectF(0,0,100,100) # Прямоугольник устройства (выходного растра)
image = QImage(rect_device.size().toSize(), QImage.Format_ARGB32_Premultiplied) # Сам растр, куда будем рисовать
image.fill(Qt.white)
painter = QPainter(image)
viewport = Viewport (rect_device, rect_scene) # viewport
context = Context(painter, viewport) # контекст
            
point = Point(None, 0, 0) #Точка без указания координатной системы
style = MapBasicStyle().styleFromString('Symbol (33,255,14)') # Cтиль точки
point_device = point.transformed(context.sceneToDeviceTransform()) # Преобразуем в координаты выходного растра
style.draw(point_device, context) # Отрисовка
image.save('/tmp/out.png') # Сохраним в файловой системе
painter.end()
#painter = None
