import axioma.app
from axioma.core.sql import *
from axioma.core.dp import *
from axioma.common import RuntimeException

'''
Пример выполнения простейшего sql запроса к данным и измененния данных в таблице посредством sql предложений.
'''

world_table_file = "/tmp/world.tab"

# Откроем таблицу
table = axioma.core.open_json({'src': world_table_file})

# Создание контента таблицы
#create table context
context = SimpleTableContext(table)

# Выборка по значению атрибута. Результат представлен в виде таблицы
# SELECT AS TABLE
print("===SELECT AS TABLE=== " "Страны с названием 'Hungary'")
query_text = "SELECT * FROM world WHERE country=\"Hungary\""
select_table = selectAsTable(query_text, context)

print("Имя таблицы выборки: %s" % select_table.name())
print("Количество записей: %d" % select_table.count())
print("Количество атрибутов: %d" % len(select_table.attributeNames()))

# SELECT
print("===SELECT=== " "Страны с населением более 100 миллионов")
query_text = "SELECT Страна FROM world WHERE Население>100000000"
result = select(query_text, context)

print([feature.getAttribute("Страна") for feature in result.features])

# Изменение данных в таблице
try:
    query_update = 'UPDATE world SET Грамотность = 99 WHERE Континент = "Африка"'
    res = update(query_update, context)
    print('Измененных записей {}'.format(res))
except RuntimeException as ex:
    print("Ошибка: %s" % ex)

# Удаление данных из таблицы по условию
try:
    query_delete = 'DELETE FROM world WHERE Грамотность < 10'
    res = remove(query_delete, context)
    print('Удаленных записей {}'.format(res))
except RuntimeException as ex:
    print("Ошибка: %s" % ex)

# table.commit() # Сохранение данных в файле
table.restore() # восстановление исходных данных

# Попытка изменить несуществующую колонку
# INVALID UPDATE
print("===INVALID UPDATE=== " "Неизвестная колонка")
try:
    query_text = 'UPDATE world SET {0}=\"{2}\" WHERE {0}=\"{1}\"'.format("a", "b", "c")
    res = update(query_text, context)
except RuntimeException as ex:
    print("Ошибка: %s" % ex)

# Попытка удаление по несуществующему атрибуту
# INVALID DELETE
print("===INVALID DELETE=== " "Неверный тип запроса")
try:
    query_text = 'UPDATE world SET {0}=\"{2}\" WHERE {0}=\"{1}\"'.format("a", "b", "c")
    res = remove(query_text, context)
except RuntimeException as ex:
    print("Ошибка: %s" % ex)
