import sys
import axioma.app
from axioma.core.plugin import *

'''
Пример расширения, которое отслеживает изменение каталога с данными. Например, открытие или закрытие таблицы
'''

class CatalogActionExtension(axioma.core.plugin.Extension):
    def __init__(self):
        super().__init__()
        self.__catalog=self.createDependencyGetter(axioma.core.dp.DataCatalogInterface) # Зависимость от существующего каталога данных

    def isReady(self):  # Зависимость разрешена
        if self.__catalog() is not None:
          self.__catalog().updated.connect(self.onUpdatedCatalog) # Подключаемся к событию измениния контента каталога данных
        return super().isReady()

    def onUpdatedCatalog(self): # Выполняется по изменению контента каталога
      print ('Каталог был изменен')
      
    def __del__(self): 
      self.__catalog().updated.disconnect(self.onUpdatedCatalog)
 
def createExtensions():
    ext = CatalogActionExtension()
    #axioma.app.core.prependExtension(ext)
    return [ext]
