import sys
from PyQt5.QtGui import *
import axioma.app
import axioma.gui
from axioma.core.dp import *
from axioma.core.geometry import *
from axioma.utils import *
from axioma.render import *
from axioma.cs import *

'''
Запрос метаданных БД PostgreSQL.
Запрос информации по таблице mapinfo_mapcatalog.
'''

a = axioma.app.AxiomaApplication(sys.argv)
gui = axioma.gui.Gui()
gui.initialize()

# Запрос метаданных системного словаря БД
def getMetadata(dataSource):
    meta = dataSource.metadata()
# атрибуты таблицы
    for attr in meta.tableAttributes('public', 'world'):
        print("ATTR", attr.name(), attr.displayClassName(), attr.type())
# Унакальные поля таблицы
    print("UNIQUE", meta.tableUniqueFields('public', 'world'))
# Ограничивающий прямоугольник таблицы
    print("B_RECT", meta.boundingRect('public', 'world', 'geometry'))
# Параметры геометрии
    print("GEOMETRY", meta.geometryParams('public', 'world'))

# Работа с таблицей MAPINFO_MAPCATALOG
def getMapcatalog(dataSource):
    mapCatalog = dataSource.mapinfoMapcatalog()
# Ограничивающий прямоугольник таблицы
    print("B_RECT_CATALOG", mapCatalog.rect('public', 'world'))
# Координатная система
    cs = mapCatalog.coordSystem('public', 'world')
    if cs is not None:
        print("COORDSYS_CATALOG", cs.prjStr())
# Установка (в БД) наименования поля со стилем
    mapCatalog.setStyleAttributeName('public', 'world', 'style')
# Установка (в БД) стиля
    mapCatalog.setMapinfoStyleString('public', 'world', 'Pen (1,2,0) Brush (2,255,16777215)')

try:
    # Открытие таблицы из СУБД PostgreSQL
    json = {
        "openWith": "PgDataProvider",
        "src": "<Адрес сервера БД>",
        "port": 5432,
        "db": "<Имя базы данных>",
        "user": "<Имя прользователя>",
        "password": "<Пароль>",
        "obj": "world"
    }
    table = axioma.core.open_json(json)

    # Получение источника таблицы, то есть самой СУБД
    dataSource = table.originalSource()

    if dataSource is not None:
# Получение метаданных
        getMetadata(dataSource)
# Работа с Mapcatalog
        getMapcatalog(dataSource)
except Exception as ex:
    print('Ошибка:', ex)

print("Done")
