#!/usr/bin/python3
# -*- coding: utf-8 -*-

"""
Пример отрисовки легенды в диалоговом окне для текущей карты
"""

# Импорт
from axioma.render import *

from PyQt5.QtCore import  *
from PyQt5.QtGui import *
from PyQt5.QtWidgets import *

class StyleDialog(QDialog):
    
    def __init__(self, parent, layers):
        QDialog.__init__(self, parent)
        self.setGeometry(200, 200, 600, 400)
        self.setWindowTitle('Пример легенды')
        self.layers = layers # Перечень слоев, для которых будет строиться легенда
        self.image = QImage() # временный растр, куда производится отрисовка легенды
        
# Создание контекста
    def createContext(self, painter):
        deviceRect = sceneRect = QRectF(0,0,200,200)
        viewport = Viewport (deviceRect,sceneRect)
        return Context(painter, viewport)
        
# Отрисовка эдемента легенды
    def drawElement(self, fi, context, pos):
        r = fi.rect()
        fi.draw(context, pos)
        pos.setY(pos.y() + 10 + r.height())
        return pos
        
    def renderLegend(self): # Рисуем в растр
        self.image = QImage(self.size(), QImage.Format_ARGB32_Premultiplied)
        painter = QPainter(self.image)
        painter.fillRect(self.image.rect(), Qt.white)
        context = self.createContext(painter)
        pos = QPoint(10, 10)
        for lay in self.layers:
            if isinstance(lay, HasStyles): # Если есть легенда
                fi = FeatureLegendItem(lay, lay.name(), self)
                pos = self.drawElement(fi, context, pos)
                if isinstance(lay, LayerWithThematic):
                    thematics  = lay.createLegendsList() # Перечень легенд для тематики, если таковые имеются
                    for them in thematics:
                        pos = self.drawElement(them, context, pos)

    def paintEvent(self, event):
        try:
            painter = QPainter(self)
            if not self.image.isNull():
                painter.drawImage(0,0, self.image)
        except Exception as ex:
            print(ex)
            
    def resizeEvent(self, event):
        self.renderLegend()


#axioma.app.mainWindow.newLegend() # Создание окна легенды для текущего окна карты (раскомментировать, если это необходимо)

 # Текущая карта
mapview = axioma.app.mainWindow.mapViewManager().currentMapView()
if mapview is not None:
    layers = mapview.map().flatLayerList() # Список слоёв карты
    dlg = StyleDialog(axioma.app.mainWindow, layers)
    dlg.exec()
else:
    QMessageBox.information(axioma.app.mainWindow, QObject().tr("Информация"), QObject().tr("Текущая карта не найдена"))
