#!/usr/bin/python3
# -*- coding: utf-8 -*-

# Import
import sys
import axioma.core
from axioma.cs import *
from PyQt5.QtCore import *
from PyQt5.QtGui import QGuiApplication

a = QGuiApplication(sys.argv)
core = axioma.core.Core()
core.initialize()

def checkCoordSystem(cs):
  if cs is not None:
    print ("Ok: %s" % cs.description())
    return True
  else:
    print ("Ошибка")
    return False

# Инициализация координатной системы из EPSG
cs_latlon = axioma.app.csfactory.createFromEpsg(4326)
checkCoordSystem(cs_latlon)
print ("IsLatLong: %r" % cs_latlon.isLatLong())

# Инициализация координатной системы из строки MapInfo PRJ
cs_merc = CoordSysFactory.defaultCoordSysFactory().createFromPrj("Earth Projection 10, 104, \"m\", 0")
if checkCoordSystem(cs_merc):
    print ("IsLatLong: %r" % cs_merc.isLatLong())

# Инициализация координатной системы из строки proj4
robin_proj4_str = "+proj=robin +lon_0=0 +x_0=0 +y_0=0 +ellps=clrk66 +towgs84=-8,160,176,-0,-0,-0,0 +units=m +no_defs"
robin_proj4 = CoordSysFactory.defaultCoordSysFactory().createFromProj(robin_proj4_str)
checkCoordSystem(robin_proj4)

# Инициализация координатной системы из строки WKT
ll_wkt_str = "GEOGCS[\"unnamed\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563],TOWGS84[0,0,0,-0,-0,-0,0]],PRIMEM[\"Greenwich\",0],UNIT[\"degree\",0.0174532925199433]]"
ll_wkt = CoordSysFactory.defaultCoordSysFactory().createFromWkt(ll_wkt_str)
if checkCoordSystem(ll_wkt):
    print("Mapbasic string: %s" %  ll_wkt.prjStr())

# Экспорт в WKT
wkt = cs_latlon.exportToWkt()
print(wkt)
ll_wkt_2 = CoordSysFactory.defaultCoordSysFactory().createFromWkt(wkt)
checkCoordSystem(ll_wkt_2)

# Локальная координатная система
cs_ne = CoordSysFactory.defaultCoordSysFactory().createFromPrj("NonEarth 0,1")
if checkCoordSystem(cs_ne):
    print ("IsNonEarth: %r" % cs_ne.isNonEarth())

# Расстояние между двумя точками в проекции и на сфере
print( "Cartesian distance %f" % cs_latlon.cartesianDistance(QPointF(0.0, 0.0), QPointF(45.0, 45.0)))
sd = cs_latlon.sphericalDistance(QPointF(0.0, 0.0), QPointF(45.0, 45.0))
print( "Spherical distance %f (success=%r)" % (sd[0], sd[1]))

# Получение ограничивающего прямоугольника для кординатной системы
rect = cs_merc.rectNumericCoordSys();
print ("Rect of CoordSystem: (%.1f %.1f) (%.1f %.1f)" % (rect.left(), rect.top(), rect.right(), rect.bottom()))

# Сравнение двух координатных систем
print ("Compare CoordSystems: %r %r" % ( cs_latlon.isEqual(robin_proj4), cs_latlon.isEqual(cs_merc)))

# Прямое и обратное преобразование координат (forward / inverse)
p_out = QPointF()
p_in = QPointF(45.0, 45.0)
res = cs_latlon.forward(p_in, p_out) # Из градусов в метры
if res:
    print ("Forward (%f, %f) res=%r" % (p_out.x(), p_out.y(), res))
p_out1 = QPointF()
res = cs_latlon.inverse(p_out, p_out1) # Из метров в градусы
if res:
    print ("Inverse (%f, %f) res=%r" % (p_out1.x(), p_out1.y(), res))

# Преобразование из одной координатной системы в другую
transform = CoordTransform(cs_latlon, robin_proj4)
p_out = transform.forward(p_in)
print ("p_out = (%f, %f)" % (p_out.x(), p_out.y()))

# Получение координат mgrs
mgrs = Mgrs(cs_latlon)
print("mgrs %s" % mgrs.getMGRSString(-45, 45))


