from axioma.render import *
from axioma.mapinfo import *

'''
Пример смены оформления для слоя. Для простоты изменим только стиль площадных объектов.
Перед запуском необходимо открыть карту с полигональными объектами.
'''

mv_man = axioma.app.mainWindow.mapViewManager()
if not mv_man.mapViews():
    raise RuntimeException("Отсутствуют открытые карты")
mv = mv_man.mapViews()[0]
# Берем первый слой открытой карты
layer = mv.allTableLayersWithoutCosmetic()[0]
props = layer.featureLayerProperties()
# Задаем новый стиль
simpleStyle = MapBasicStyle().styleFromString("Pen (1, 2, 0) Brush (2, 255)")
props.uniformStyleProvider().collectionStyle().setStyle(PolygonalGeometryClass(), simpleStyle)
# Переопределять стиль для слоя
props.setShowUniformly(True)
layer.setProperties(props)

#обновим слой на карте
layer.needRedraw.emit(layer)


