import sys
import axioma.core
from axioma.core.dp import *
from PyQt5.QtGui import QGuiApplication

'''
Пример открытия таблицы sqlite.
'''

a = QGuiApplication(sys.argv)
core = axioma.core.Core()
core.initialize()

# Открытие таблицы sqlite
json = {
    "openWith": "SqliteDataProvider",
    "src": "C:\\axioma_project\\Axioma-gis\\test-data\\sqlite\\mapinfocomp_utf8.sqlite",
    "obj": 'world',
}
table = axioma.core.open_json(json)

# Запрашиваем первую запись
features = table.selectToFeatureList(QuerySelectAll(table.tableSchema().attributeNames()), PageRange(0, 1))
print(table.tableSchema().attributeNames())
if (len(features)):
    
    # Берем первый элемент массива
    feature = features[0]
    print("Geom", feature.getAttribute("GEOMETRY"))

# Запросим последовательно порциями по 10 записей
count = table.count()
print('Общее количество записей =', count)
part_count = 10
start_record = 0
while start_record < count:
    print('--- Запрашиваем от {} до {}'.format(start_record+1, start_record+part_count))
    features = table.selectToFeatureList(QuerySelectAll(table.tableSchema().attributeNames()), PageRange(start_record, part_count))
    start_record = start_record + part_count
    for f in features:
        print('ID =', f.id())

# Последовательный запрос всех записей таблицы
#        features = table.allFeatures()
#        for f in features:
#            print("id", f.id(), f.getAttribute('Страна'))
