from axipy.cs.CoordSystem import CoordSystem
from .data_provider import DataProvider, Table
from .source import Source, Destination, Schema
from typing import List, Optional


class TmsSource(Source):
    pass


class TmsDataProvider(DataProvider):
    """Провайдер для тайловых серверов.
    """
    _identifier = 'TmsDataProvider'

    def get_source(self, templateUrl: str, minLevel: int = 0, maxLevel: int = 19, size: tuple = (256, 256), 
                    type_address: str = "xyz", watermark: str ='', watermark_style: str ='', prj: str = None, live_time: int = 0) -> Source:
        """ Создает источник данных
        templateUrl: Шаблон для запроса данных. Например, `https://maps.axioma-gis.ru/osm/{LEVEL}/{ROW}/{COL}.png`
        minLevel: Минимальный уровень показа
        maxLevel: Максимальный уровень показа
        size: Размер тайлов
        type_address: Тип адресации к тайлам. Поддерживается два значения: 'xyz' и 'quadkey'
        watermark: Ссылка на правообладателя
        watermark_style: Стиль оформления текста, с коротым на карте будут отображаться данные о правообладателе.
        prj: Строка с Системой Координат. Если None, то используется значение по умолчанию (CoordSys Earth Projection 10, 157, 'm')
        live_time: время жизни тайла в секундах. Если равно 0, то значение не учитывается.
        """
        return TmsSource(
            Source._provider(self.id),
            {
                'src': templateUrl,
                'minLevel' : minLevel,
                'maxLevel' : maxLevel,
                'tileSize': '{}x{}'.format(size[0], size[1]),
                'typeAddress' : type_address,
                'watermarkText': watermark,
                'watermarkStyle': watermark_style,
                'prj': prj,
                'liveTime': live_time
            }
        )

  
