from axipy import *
from PySide2.QtWidgets import QAction
from PyQt5.QtCore import QTimer


class Plugin:
    def __init__(self, iface):
        self.action = None
        self.menu = None
        self.notifications = iface.notifications
        self.timer = QTimer()
        self.timer.setInterval(1000)
        self.timer.start()
        self.timer.timeout.connect(self.init_menu)

    def init_menu(self):
        from axipy.app import mainwindow
        if mainwindow.is_valid:
            actName = "TmsDataProviderMenuAction"
            actions = mainwindow.qt_object().findChildren(QAction, actName)
            if (len(actions)):
                self.menu = actions[0].menu()
                self.action = self.menu.addAction('Публичная кадастровая карта')
                self.action.triggered.connect(self.show_map)
                self.timer.stop()
            else:
                print('Действие {} не найдено'.format(actName))

    def unload(self):
        if self.action is not None:
            self.menu.removeAction(self.action)

    def show_map(self):
        self.notifications.push ('Предупреждение', 'Отрисовка данных кадастровой карты на некоторых масштабах может производиться с временной задержкой.')

        rest_raster = provider_manager.rest.open('https://pkk.rosreestr.ru/arcgis/rest/services/PKK6/CadastreObjects/MapServer')
        rest_raster.name = 'rosreestr'
        rest_layer = Layer.create(rest_raster)
        rest_layer.zoom_restrict = True
        rest_layer.max_zoom = 3000
        rest_layer.title = 'Крупный масштаб'

        prj_mercator = 'CoordSys Earth Projection 10, 104, "m", 0 Bounds (-20037508.34, -20037508.34) (20037508.34, 20037508.34)'
        osm_raster = provider_manager.tms.open('http://maps.axioma-gis.ru/osm/{LEVEL}/{ROW}/{COL}.png', prj=prj_mercator)
        osm_raster.name = 'osm'
        osm_layer = Layer.create(osm_raster)
        osm_layer.title = 'Подложка'

        rr_raster = provider_manager.tms.open('https://pkk.rosreestr.ru/arcgis/rest/services/Hosted/caddivsion/VectorTileServer/tile/{LEVEL}/{COL}/{ROW}.pbf',
           size=(1024, 1024), watermark='<a href="http://rosreestr.ru/">© Росреестр</a>')
        rr_raster.name = 'rosreestr_large'
        rr_layer = Layer.create(rr_raster)
        rr_layer.zoom_restrict = True
        rr_layer.min_zoom = 3000
        rr_layer.title = 'Мелкий масштаб'

        map = Map([ rest_layer, rr_layer, osm_layer ])

        mapview = view_manager.create_mapview(map)
        mapview.coordsystem = CoordSystem.from_prj('Earth Projection 10, 104, "m", 0')
        k = mapview.device_rect.width / mapview.device_rect.height
        center = Pnt(4187951, 7474203)
        half_zoom = 4500 / 2
        half_height = half_zoom / k
        mapview.scene_rect = Rect(center.x - half_zoom, center.y - half_height, center.x + half_zoom, center.y + half_height)
