from PyQt5.QtGui import QMouseEvent, QIcon
from PyQt5.QtCore import Qt
from axioma.gui import *
import axioma.gui.extension
from axioma.core.plugin import *

'''
Пример реализации простейшего инструмента для карты в виде расширения. 
По нажатию левой кнопки мыши выводятся координаты на карте
'''

# Определяем свой класс инструмента
class ExampleTool(Tool):

    def mousePressEvent(self, event):
        if event.button() != Qt.LeftButton:
            return
        posOnMap = self.widget().viewport().mapToScene(event.pos()) # Преобразуем координаты из окна в координаты карты
        print("Координаты точки карты ({}, {})".format(posOnMap.x(), posOnMap.y())) # выводим полученную координату
        return Tool.PassEvent

# Регистрируем расширение в системе.
ext = axioma.gui.extension.BasicToolExtension(ExampleTool, axioma.gui.MapView, "ExampleToolId", icon=QIcon.fromTheme("info"), text="Координаты точки карты")
axioma.app.gui.prependExtension(ext)

# Добавляем инструмент в закладку карты
ribbonExt = axioma.gui.extension.RibbonExtension()
ribbonExt.addAction("ExampleToolId", "map", "operations")
axioma.app.gui.prependExtension(ribbonExt)
