from PyQt5.QtGui import QMouseEvent, QIcon
from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QMessageBox
from axioma.gui import *
import axioma.gui.extension
from axioma.core.plugin import *

'''
Пример реализации простейшего инструмента для карты в виде расширения с пользовательским контроллером.
Контроллер может давать возможность дополнительно управлять доступностью инструмента.
По нажатию левой кнопки мыши выводятся координаты на карте.
'''

# Определяем свой класс инструмента
class ExampleTool(Tool):

    def mousePressEvent(self, event):
        if event.button() != Qt.LeftButton:
            return
        posOnMap = self.widget().viewport().mapToScene(event.pos()) # Преобразуем координаты из окна в координаты карты
        mess="Координаты точки карты:\n ({}, {})".format(posOnMap.x(), posOnMap.y()) # выводим полученную координату
        QMessageBox.information(axioma.app.mainWindow, "Информация", mess)
        return Tool.PassEvent

# Определяем контроллер для создания нашего инструмента
class ExampleToolController(axioma.gui.extension.ToolController):
    def __init__(self, parent=None):
        super().__init__( axioma.gui.MapView, parent) # Только для карт

# Переопределяем метод создания инструмента
    def createTool(self, widget):
        return ExampleTool(widget)

#  Если мы хотим дополнительно управлять доступностью инструмента для окна
#    def isEnabledFor(self, widget):
#        return True

# Регистрируем расширение в системе.
ext = axioma.gui.extension.ToolControllerExtension(ExampleToolController, "ExampleToolId", icon=QIcon("://icons/32px/info.png"), text="Координаты точки карты")
axioma.app.gui.prependExtension(ext)

# Добавляем инструмент в закладку карты
ribbonExt = axioma.gui.extension.RibbonExtension()
ribbonExt.addAction("ExampleToolId", "map", "operations")
axioma.app.gui.prependExtension(ribbonExt)
