import axioma.core.geometry
from axioma.mapinfo import MapBasicStyle
from axioma.render import *
from PyQt5.QtCore import  Qt
from PyQt5.QtGui import QColor

'''
Пример работы с менеджером стилей. Рассмотрим получение и замену стиля для нового объекта на примере точечного объекта.
Этот стиль используется как стиль для вновь создаваемых объектов на в окне карты или отчета, а также может быть использован для
создания геометрических объектов программным способом.
'''

# Запрашиваем текущий стиль для новых объектов
object_style=axioma.app.render.styleService().newObjectStyle()

# Вывод (для визуального) в формате MapInfo MapBasic
print(MapBasicStyle().stringFromStyle(object_style))

# Создадим стиль для точечных объектов, который мы хотим использовать для новых объектов
point_style=MapBasicStyle().styleFromString("Symbol (36,%d, 24)"  % (QColor(Qt.blue).rgb() - 0xFF000000 ))
print(MapBasicStyle().stringFromStyle(point_style))

# Переопределяем стиль. Данный стиль может быть использоваться для создания новых объектов. Переопределенный стиль хранится до концасессии.
# Для постоянного переопределения необходимо произвести можификацию через настройти.
object_style.setStyle(PointGeometryClass(), point_style)

# Вывод полученного результата. Так-же данный стиль можно посмотреть в настройках аксиомы
print(MapBasicStyle().stringFromStyle(axioma.app.render.styleService().newObjectStyle()))

# Запрос стиля для точечного объекта
point=axioma.core.geometry.Point(None, 0, 0) # Требуемый объект
point_style=axioma.app.render.styleService().newObjectStyle().style(point)# Запрос поддерживаемого стиля для геометрии
print(MapBasicStyle().stringFromStyle(point_style))

# Запрос стиля для полигонального объекта не по геометрическому объекту, а по его типу
polygon_style=axioma.app.render.styleService().newObjectStyle().style(PolygonalGeometryClass())
print(MapBasicStyle().stringFromStyle(polygon_style))
