from axioma.core.dp import *
from axioma.cs import CoordSysFactory
from PyQt5.QtCore import QPointF
from axioma.plugin.gdal import *
from axioma.raster import saveRegistration
import axioma.app

'''
Пример привязки растрового изображения. Привязывать будем копию входного файла.
'''

input_file = "/tmp/image.png"
output_file = "/tmp/image_out.png"

if input_file == "" or output_file == "":
    raise ValueError("Входной и/или выходной файлы не заданы")

def open_raster(filename):
    fd = FileDefinition(filename)
    gdp = axioma.app.gui.dataProviderById("GdalDataProvider")
    lds = LazyGdalDataSource(fd, gdp)
    return LazyGdalDataObject(lds)

print("==========work_with_raster_demo===========")

# открываем файл
raster = open_raster(input_file)

# Получение QImage
# obtain QImage
img = raster.imageRect(raster.rect(), raster.size())

# Сохранение растра, см. методы QImage
# save, see QImage methods
print("Сохранение растра '%s' прошло %s с именем '%s'" % (input_file,
                                                        ("удачно" if img.save(output_file) else "неудачно"),
                                                         output_file))


print("==========save_registration===========")
# Откроем сохраненный растр и произведем его привязку
# let's open new raster and save registration for it

# Выходной файл
# open file
raster2reg = open_raster(output_file)

# Слздание контейнера для точек привязки
# init gcps
binding_def = BindingDefinition()

# Задание точек привязки
# fill gcps
gcps = [PointBinding(QPointF(0, 0), QPointF(0, 0)),
        PointBinding(QPointF(0, 200), QPointF(0, 10)),
        PointBinding(QPointF(200, 0), QPointF(-10, 0))]

# Установка координатной системы для выходного файла.
#set coord system
cs_factory = CoordSysFactory.defaultCoordSysFactory()

binding_def.setAllPoints(gcps)
binding_def.setCoordSystem(cs_factory.LatLongCoordSystem())
saveRegistration(raster2reg, binding_def)
print("Растр '%s' %s привязан" % (output_file, ("успешно" if img.save(output_file) else "не был")))
