import sys
import PyQt5.QtCore
import PyQt5.QtGui
from PyQt5.QtGui import QMouseEvent
from PyQt5.QtWidgets import *
from PyQt5.QtGui import QIcon
from PyQt5.QtCore import QObject, Qt
import axioma.gui.extension
import axioma.app
from axioma.gui import RibbonId, SnapTool

'''
Пример инструмента с поддержкой возможности привязки к координатам.
Работа инструмента требует включения в  окне карты режима привязки к координатам (клавиша "S").
'''

# Пользовательский инструмент
class MyTool(axioma.gui.Tool):
    def __init__(self, snapTool, view):
        super().__init__(view)
# Сохраним ссылку на snap объект
        self.__snapTool = snapTool
        
    def mousePressEvent(self, event):
        try:
# Если нажали левую клавишу мыши
            if (event.button() == Qt.LeftButton):
# Координаты сцены по нажатию
             currentPoint = self.__snapTool.scenePoint()
             mess = 'Исходная точка ({}, {})'.format(currentPoint.x(), currentPoint.y())
             if self.__snapTool.isSnapped():
# Исправленные координаты
                snappedPoint = self.__snapTool.snapPoint()
                mess = mess + '\n' + 'Исправленная точка ({}, {})'.format(snappedPoint.x(), snappedPoint.y())
             else:
               mess = mess + '\n' + "Окно не находится в режиме привязки узлов";
             QMessageBox.information(axioma.app.mainWindow, "Результат", mess)
        except Exception as ex:
            print(ex)
        finally:
            return super().mousePressEvent(event)

# Определяем контроллер для создания нашего инструмента. Доступен также если нет редактируемого слоя.
class MySnapToolController(axioma.gui.extension.DrawingToolController):
    def __init__(self, parent=None):
        super().__init__( parent)

# Переопределяем метод создания инструмента
    def createTool(self, widget):
# Создаем инструмент в виде контейнера инструментов
        chain = axioma.gui.ChainTool(widget)
# Добавляем поддержку snap
        snap = axioma.gui.SnapTool(widget)
        chain.addSubtool(snap)
# Добавляем пв контейнер наш инструмент. При этом ему передаем ссылку на инструмент snap
        simple = MyTool(snap, widget)
        chain.addSubtool(simple)
        return chain

# Если требуется дополнительное управление доступностью инструмента
#    def  isEnabled(self, widget):
#        return True

def createMyExtensions():
# Создаем новую группу в панели карты
    ribbonExt = axioma.gui.extension.RibbonExtension()
    ribbonExt.addGroup("map","SnapGroupId", "Узлы")
# Создаем расширение на базе ранее определенного контроллера
    toolExt = axioma.gui.extension.ToolControllerExtension(MySnapToolController, "MySnapTool", icon=QIcon.fromTheme("snap_geometries"), text="Пример инструмента со SNAP")
    ribbonExt.addAction("MySnapTool", "map", "SnapGroupId")
    return [ribbonExt, toolExt]
